<?php

/**
 * This is the model class for table "{{app_youtube_link}}".
 *
 * The followings are the available columns in table '{{app_youtube_link}}':
 * @property integer $id
 * @property integer $category_id
 * @property string $youtube_link
 * @property string $launch_date
 * @property string $isActive
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 * @property string $app_icon
 * @property string $recommended
 * @property integer $trending_count
 */
class AppYoutubeLink extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{app_youtube_link}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('category_id, youtube_link, launch_date, isActive, created_by, created_date_time, trending_count', 'required'),
			array('category_id, created_by, updated_by, trending_count', 'numerical', 'integerOnly'=>true),
			array('youtube_link, app_icon', 'length', 'max'=>255),
			array('isActive, recommended', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, category_id, youtube_link, launch_date, isActive, created_by, created_date_time, updated_by, updated_date_time, app_icon, recommended, trending_count', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'category' => array(self::BELONGS_TO,'MasterCategory', 'category_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'category_id' => 'Category',
			'youtube_link' => 'Youtube Link',
			'launch_date' => 'Launch Date',
			'isActive' => 'Is Active',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
			'app_icon' => 'App Icon',
			'recommended' => 'Recommended',
			'trending_count' => 'Trending Count',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('category_id',$this->category_id);
		$criteria->compare('youtube_link',$this->youtube_link,true);
		$criteria->compare('launch_date',$this->launch_date,true);
		$criteria->compare('isActive',$this->isActive,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);
		$criteria->compare('app_icon',$this->app_icon,true);
		$criteria->compare('recommended',$this->recommended,true);
		$criteria->compare('trending_count',$this->trending_count);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return AppYoutubeLink the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
