<?php

/**
 * This is the model class for table "{{_user}}".
 *
 * The followings are the available columns in table '{{_user}}':
 * @property string $id
 * @property string $user_type_id
 * @property string $user_name
 * @property string $email
 * @property string $password
 * @property string $phone_number
 * @property string $mobile_phone_number
 * @property string $company_name
 * @property string $designation
 * @property string $industry_id
 * @property string $country_id
 * @property string $isActive
 *
 * The followings are the available model relations:
 * @property Faq[] $faqs
 * @property Faq[] $faqs1
 * @property Ticket[] $tickets
 * @property Ticket[] $tickets1
 * @property Industry $industry
 * @property UserType $userType
 * @property User $country
 * @property User[] $users
 */
  
  class SecondaryActiveRecord extends CActiveRecord {
    public function getDbConnection() {
        return Yii::app()->support;
    }
}
class SupportUser extends SecondaryActiveRecord
{
	public $re_enter_password;
	public $rememberMe;
	public $_identity;
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return User the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{_user}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_type_id, user_name, email, password, re_enter_password, phone_number, company_name, designation, industry_id, country_id', 'required','on'=>array('signup')),
			array('user_name','unique','on'=>array('signup')),
			array('user_type_id, phone_number, mobile_phone_number, industry_id', 'length', 'max'=>20),
			array('user_name, email, password, company_name, designation', 'length', 'max'=>255),
			array('email','email'),
			array('country_id', 'length', 'max'=>5),
			array('isActive', 'length', 'max'=>1),
			
		    array('password, re_enter_password', 'required','on'=>array('change_password')),
		    array('password, re_enter_password', 'length', 'min'=>6, 'max'=>40,'on'=>array('signup','change_password')),
            array('re_enter_password', 'compare', 'compareAttribute'=>'password','on'=>array('signup','change_password')),

            array('password', 'authenticate', 'on'=>'login'),
			
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, user_type_id, user_name, email, phone_number, mobile_phone_number, company_name, designation, industry_id, country_id, isActive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'user_type_id' => 'Role',
			'user_name' => 'User Name',
			'email' => 'Email',
			'password' => 'Password',
			'phone_number' => 'Phone Number',
			'mobile_phone_number' => 'Mobile Phone Number',
			'company_name' => 'Company Name',
			'designation' => 'Designation',
			'industry_id' => 'Industry',
			'country_id' => 'Country',
			'isActive' => 'Is Active',
			're_enter_password'=>'Please confirm your password'
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
	}
	
	/**
	 * Authenticates the password.
	 * This is the 'authenticate' validator as declared in rules().
	 */
	public function authenticate($attribute,$params)
	{
		if(!$this->hasErrors())
		{
			$this->_identity=new UserIdentity($this->user_name,$this->password);
			if(!$this->_identity->authenticate())
			{
				if($this->user_name=='')
					$this->addError('user_name','Enter username.');
				if($this->password=='')
					$this->addError('password','Enter password.');
				if($this->user_name!='' &&$this->password!='' )
				$this->addError('password','Incorrect username or password.');
			}
		}
	}

	/**
	 * Logs in the user using the given username and password in the model.
	 * @return boolean whether login is successful
	 */
	public function login()
	{
		if($this->_identity===null)
		{
			$this->_identity=new UserIdentity($this->username,$this->password);
			$this->_identity->authenticate();
		}
		if($this->_identity->errorCode===UserIdentity::ERROR_NONE)
		{
			$duration=$this->rememberMe ? 3600*24*30 : 0; // 30 days
			Yii::app()->user->login($this->_identity,$duration);
			return true;
		}
		else
		{
			return false;
		}
	}
	
	
	/*
	*	Getting all users
	*	param: $userTypes; nil means all
	*/
	
}