<?php

/**
 * This is the model class for table "{{_product_type}}".
 *
 * The followings are the available columns in table '{{_product_type}}':
 * @property string $id
 * @property string $user_group_id
 * @property string $product_group_id
 * @property string $category_id
 * @property string $type_name
 * @property string $isActive
 *
 * The followings are the available model relations:
 * @property ProductCategory $category
 * @property UserGroup $userGroup
 * @property ProductGroup $productGroup
 */
class ProductType extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ProductType the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{_product_type}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_group_id, product_group_id, category_id, type_name', 'required'),
			array('user_group_id, product_group_id, category_id', 'length', 'max'=>20),
			array('type_name', 'length', 'max'=>255),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, user_group_id, product_group_id, category_id, type_name, isActive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'category' => array(self::BELONGS_TO, 'ProductCategory', 'category_id'),
			'userGroup' => array(self::BELONGS_TO, 'UserGroup', 'user_group_id'),
			'productGroup' => array(self::BELONGS_TO, 'ProductGroup', 'product_group_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'user_group_id' => 'Sub Category',
			'product_group_id' => 'Product Group',
			'category_id' => 'Product Sub Group',
			'type_name' => 'Type',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.
                $user = trim(Yii::app()->request->getParam('user'));
                $cat = trim(Yii::app()->request->getParam('cat'));
                $pro_group = trim(Yii::app()->request->getParam('pro_group'));
                $type = trim(Yii::app()->request->getParam('type'));
		$criteria=new CDbCriteria;
		$criteria->with	=	array('userGroup','productGroup','category');
		
		$criteria->compare('id',$this->id,true);
		$criteria->compare('t.user_group_id',$this->user_group_id,true);
		$criteria->compare('t.product_group_id',$this->product_group_id,true);
		$criteria->compare('t.category_id',$this->category_id,true);
		$criteria->compare('type_name',$this->type_name,true);
		$criteria->compare('t.isActive',$this->isActive,true);
                 if(!empty($user))
                {
                $criteria->addCondition('t.user_group_id='.$user,'AND');
                }
                if(!empty($cat))
                {
                $criteria->addCondition('t.category_id='.$cat,'AND');
                }
                if(!empty($pro_group))
                {
                $criteria->addCondition('t.product_group_id='.$pro_group,'AND');
                }
                if(!empty($type))
                {
                $criteria->addCondition('t.type_name like "%'.$type.'%"','AND');
                }
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,'pagination'=>false
		));
	}
	
	public function getProductType($user_group_id=null,$product_group_id=null,$product_category_id=null,$getAll=false)
	{
		$condition	=	'isActive =  "Y"';	
			
		if($user_group_id!=null) 
			$condition	.=	' AND user_group_id =  '.$user_group_id;

		if($product_group_id!=null) 
			$condition	.=	' AND product_group_id =  '.$product_group_id;
			
		if($product_category_id!=null) 
			$condition	.=	' AND category_id =  '.$product_category_id;
			
		$model		=	ProductType::model()->findAll(array('condition'=>$condition,'order'=>'id'));
			return CHtml::listData($model, 'id', 'type_name');
		
		if($getAll)
		{
			$model		=	ProductCategory::model()->findAll(array('condition'=>$condition,'order'=>'id'));
			return CHtml::listData($model, 'id', 'type_name');
		}
		return array();
	}
}