<?php

/**
 * This is the model class for table "{{_product_sub_category_feature}}".
 *
 * The followings are the available columns in table '{{_product_sub_category_feature}}':
 * @property integer $id
 * @property integer $product_sub_category_id
 * @property integer $product_category_feature_id
 * @property string $feature
 * @property string $isActive
 */
class ProductSubCategoryFeature extends CActiveRecord {
public $category_id;
    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{_product_sub_category_feature}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('product_category_feature_id,feature,subcat_id', 'required'),
            array('product_category_feature_id,sort_order', 'numerical', 'integerOnly' => true),
            array('feature,subcat_id', 'length', 'max' => 255),
            array('isActive', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id,  product_category_feature_id, feature, isActive', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
           // 'productsubcategory' => array(self::BELONGS_TO, 'ProductSubCategory', 'product_sub_category_id'),
            'productcategoryfeature' => array(self::BELONGS_TO, 'ProductCategoryFeature', 'product_category_feature_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
           // 'product_sub_category_id' => 'Product Sub Category',
            'product_category_feature_id' => 'Product Category Feature',
            'feature' => 'Feature',
            'isActive' => 'Is Active',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        $search = Yii::app()->request->getParam('searchterm');
        if(!empty($search))
        $search = trim(Yii::app()->request->getParam('searchterm'));
        $criteria = new CDbCriteria;
        $criteria->with = array('productcategoryfeature');
        $criteria->compare('id', $this->id);
        //$criteria->compare('product_sub_category_id', $this->product_sub_category_id);
        $criteria->compare('product_category_feature_id', $this->product_category_feature_id);
        $criteria->compare('feature', $this->feature, true);
        $criteria->compare('isActive', $this->isActive, true);
        if (!empty($search)) {
            $criteria->addCondition('t.feature like "%' . $search . '%" OR productcategoryfeature.feature like "%' . $search . '%"  ',  'AND');
        }
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return ProductSubCategoryFeature the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }
public function getProductSubCategoryFeature($id) {

        $condition = 'isActive =  "Y" and product_category_feature_id='.$id;

        $model = ProductSubCategoryFeature::model()->findAll(array('condition' => $condition));

        return CHtml::listData($model, 'id', 'feature');
    }
    public static function getProductSubCategoryFeature1() {

        $condition = 'isActive =  "Y"';

        $model = ProductSubCategoryFeature::model()->findAll(array('condition' => $condition));

        return CHtml::listData($model, 'id', 'feature');
    }
}
