<?php

/**
 * This is the model class for table "{{_product_sub_category}}".
 *
 * The followings are the available columns in table '{{_product_sub_category}}':
 * @property integer $id
 * @property integer $main_category_id
 * @property integer $category_id
 * @property integer $sub_category_id
 * @property integer $product_category_id
 * @property string $product_sub_category
 * @property string $isActive
 */
class ProductSubCategory extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{_product_sub_category}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('main_category_id, category_id, sub_category_id, product_category_id, product_sub_category', 'required'),
            array('main_category_id, category_id, sub_category_id, product_category_id', 'numerical', 'integerOnly' => true),
            array('product_sub_category,banner', 'length', 'max' => 255),
           // array('description', 'length', 'max' =>160), 
             array('description', 'length', 'max' =>160), 
            array('isActive', 'length', 'max' => 1),
          //  array('product_sub_category', 'unique'),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, main_category_id, category_id, sub_category_id,banner,product_category_id, product_sub_category, isActive', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'maincategory' => array(self::BELONGS_TO, 'MainCategory', 'main_category_id'),
            'category' => array(self::BELONGS_TO, 'Category', 'category_id'),
            'subcategory' => array(self::BELONGS_TO, 'SubCategory', 'sub_category_id'),
            'productcategory' => array(self::BELONGS_TO, 'ProductCategory', 'product_category_id'),
            
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'main_category_id' => 'Main Category',
            'category_id' => 'Category',
            'sub_category_id' => 'Sub Category',
            'product_category_id' => 'Product Category',
            'product_sub_category' => 'Product Sub Category',
            'banner'=>'Banner',
            'isActive' => 'Is Active',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.
        $search = Yii::app()->request->getParam('searchterm');
        if(!empty($search))
        $search = trim(Yii::app()->request->getParam('searchterm'));
        $criteria = new CDbCriteria;
        $criteria->with = array('maincategory', 'category','subcategory','productcategory');
        $criteria->compare('id', $this->id);
        $criteria->compare('main_category_id', $this->main_category_id);
        $criteria->compare('category_id', $this->category_id);
        $criteria->compare('sub_category_id', $this->sub_category_id);
        $criteria->compare('product_category_id', $this->product_category_id);
        $criteria->compare('product_sub_category', $this->product_sub_category, true);
        $criteria->compare('isActive', $this->isActive, true);
        if (!empty($search)) {
            $criteria->addCondition('t.product_sub_category like "%' . $search . '%" OR maincategory.main_category like "%' . $search . '%" OR category.category like "%' . $search . '%" OR subcategory.sub_category like "%' . $search . '%" OR productcategory.product_category like "%' . $search . '%"', 'AND');
        }
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return ProductSubCategory the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }
public static function getProductSubCategory($main_category_id = null, $category_id = null, $sub_category_id = null,$product_category_id=null) {

        $condition = 'isActive =  "Y"';
        if ($main_category_id != null)
            $condition .= ' AND main_category_id =  ' . $main_category_id;

        if ($category_id != null)
            $condition .= ' AND category_id =  ' . $category_id;
        if ($sub_category_id != null)
            $condition .= ' AND sub_category_id =  ' . $sub_category_id;
        if ($product_category_id != null)
            $condition .= ' AND product_category_id =  ' . $product_category_id;
        $model =ProductSubCategory::model()->findAll(array('condition' => $condition));

        return CHtml::listData($model, 'id', 'product_sub_category');
    }
    
    
    public static function getAllProductSubCategory() {

        $condition = 'isActive =  "Y"';
        
        $model =ProductSubCategory::model()->findAll(array('condition' => $condition));

        return CHtml::listData($model, 'id', 'product_sub_category');
    }
    
    
    
    public function searchProductSubCategoryForSortOrder($product_category_id=0) {
    	// @todo Please modify the following code to remove attributes that should not be searched.
    
    	$criteria = new CDbCriteria;
    	$criteria->with = array('maincategory', 'category','subcategory','productcategory');
    
    	if (!empty($product_category_id))
    	{
    		$criteria->addCondition('t.product_category_id='.$product_category_id, 'AND');
    	}
    	$criteria->order = 't.sort_order';
    	return new CActiveDataProvider($this, array(
    			'criteria' => $criteria,
    	));
    }
}
