<?php

/**
 * This is the model class for table "{{ptp_nbd_product}}".
 *
 * The followings are the available columns in table '{{ptp_nbd_product}}':
 * @property string $id
 * @property string $terms_and_conditions
 */
class ProductNames extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Country the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{_nbd_product}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('product_name', 'required'),
			array('product_name', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, product_name', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'product_name' => 'Name',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.
                $search= trim(Yii::app()->request->getParam('searchterm'));

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);
		$criteria->compare('product_name',$this->product_name,true);
                if(!empty($search))
                {
                    $criteria->addCondition('t.product_name like "%'.$search.'%"');
                }
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
			'sort'=>array(
                        'defaultOrder'=>'t.id DESC',
       	 	),
			'pagination'=>array('pageSize'=>10)
		));
	}
	
	public function getProductNames()
	{
		$condition = 'isActive =  "Y"';
		$model = self::model()->findAll(array('condition' => $condition,'order'=>'product_name'));
		return CHtml::listData($model, 'id', 'product_name');
	}     
	
}