<?php

/**
 * This is the model class for table "{{_product_group}}".
 *
 * The followings are the available columns in table '{{_product_group}}':
 * @property string $id
 * @property string $product_group_name
 * @property string $isActive
 */
class ProductGroup extends CActiveRecord
{
	public $userGroup_search_groupname;
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @property string $user_group_id
	 * @return ProductGroup the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{_product_group}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_group_id,product_group_name', 'required'),
			//array('product_group_image', 'file','types'=>'jpg, jpeg, gif, png', 'allowEmpty'=>true, 'on'=>'update'), // this will allow empty field when page is update (remember here i create scenario update)
			array('product_group_name','unique'),
			array('user_group_id', 'length', 'max'=>20),
			array('product_group_name,product_group_icon,product_group_image', 'length', 'max'=>255),
			array('description', 'length', 'max'=>3000),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, user_group_id, product_group_name,userGroup_search_groupname isActive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
					 'userGroup' => array(self::BELONGS_TO, 'UserGroup', 'user_group_id'),
                                         'product' => array(self::HAS_MANY, 'Product', 'product_group_id'),
                                         'productmap' => array(self::HAS_MANY, 'ProductMapping', 'product_group_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'user_group_id' => 'Sub Category',
			'product_group_name' => 'Product Group',
			'userGroup_search_groupname'=>'User Group',
			'product_group_image'=>'Group Image',
                        'product_group_icon' => 'Group Icon',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.
                $user = trim(Yii::app()->request->getParam('user'));
                $group = trim(Yii::app()->request->getParam('group'));
		$criteria=new CDbCriteria;
		$criteria->with	=	array('userGroup');
		$criteria->compare('id',$this->id,true);
		$criteria->compare('user_group_id',$this->user_group_id,true);
		$criteria->compare('product_group_name',$this->product_group_name,true);
		$criteria->compare('t.isActive',$this->isActive,true);
		$criteria->compare('userGroup.id',$this->userGroup_search_groupname,true);
                
                if(!empty($user))
                {
                $criteria->addCondition('t.user_group_id='.$user,'AND');
                }
                if(!empty($group))
                {
                $criteria->addCondition('t.product_group_name like "%'.$group.'%"','AND');
                }
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
//			'pagination'=>array('pageSize'=>Yii::app()->params['defaultPageSize']),
			
			'sort'=>array(
				'defaultOrder'=>'t.id DESC',
        		'attributes'=>array(
            		'userGroup_search_groupname'=>array(
                		'asc'=>'userGroup.id',
                		'desc'=>'userGroup.id DESC',
            		),
					'*',
       			),
    		),'pagination'=>false
		));
	}
	
	public function getGroupName()
	{
		return $this->product_group_name.' ('.$this->userGroup->group_name.')';
	}
	
	//Get Category(s)
	//param group id, returning model
	public function getProductGroup($user_group_id=null,$getAll=false)
	{
		$condition	=	'isActive =  "Y"';
		if($user_group_id!=null)
		{
			$condition	.=	' AND user_group_id =  '.$user_group_id;
			$model		=	ProductGroup::model()->findAll(array('condition'=>$condition,'order'=>'product_group_name'));
			return CHtml::listData($model, 'id', 'GroupName');
		}
		if($getAll)
		{
			$model		=	ProductGroup::model()->findAll(array('condition'=>$condition,'order'=>'product_group_name'));
			return CHtml::listData($model, 'id', 'GroupName');
		}
		return array();
	}
	public function collectProductGroup($user_group_id=null)
	{
		$condition = 'isActive =  "Y" ';
		if($fid!=null) 
		$condition.=	' AND user_group_id =  '.$user_group_id;
		$model = ProductGroup::model()->model()->findAll(array('condition'=>$condition,'order'=>'product_group_name'));
		return CHtml::listData($model, 'id', 'GroupName');

	}
}
