<?php

/**
 * This is the model class for table "{{_product_feature}}".
 *
 * The followings are the available columns in table '{{_product_feature}}':
 * @property integer $id
 * @property string $feature_name
 * @property string $isActive
 */
class ProductFeature extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ProductFeature the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{_product_feature}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('feature_name', 'required'),
			array('feature_name', 'unique'),
			array('feature_name', 'length', 'max'=>255),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, feature_name, isActive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'feature_name' => 'Product Feature',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.
		$searchterm = Yii::app()->request->getParam('term');
		if(!empty($searchterm))
        $searchterm = trim(Yii::app()->request->getParam('term'));
		$status= Yii::app()->request->getParam('status');
		if(!empty($status))
        $status= trim(Yii::app()->request->getParam('status'));
		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('feature_name',$this->feature_name,true);
		$criteria->compare('isActive',$this->isActive,true);
        if(!empty($searchterm))
        {
             $criteria->addCondition('t.feature_name like "%'.$searchterm.'%"','AND');
        }
        if(!empty($status))
        {
        	$criteria->addCondition('t.isActive like "%'.$status.'%"','AND');
        }
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
			'sort'=>array(
            'defaultOrder'=>'t.id DESC',
       	 	),
		//'pagination'=>false
                    ));
	}
	
	//Get Features(s)
	//param group id, returning model
	public function getProductFeature($needList=true,$fid=null)
	{
		$condition	=	'isActive =  "Y" ';
		if($fid!=null) 
		$condition	.=	'AND id =  '.$fid;
		$model		=	ProductFeature::model()->model()->findAll(array('condition'=>$condition,'order'=>'id'));
		if($needList)
			return CHtml::listData($model, 'id', 'feature_name');
		return $model;
	}
        
        
        public static function getAllProductFeature($needList=true,$fid=null)
	{
		$condition	=	'isActive =  "Y" ';
		$model		=	ProductFeature::model()->model()->findAll(array('condition'=>$condition,'order'=>'id'));
			return CHtml::listData($model, 'id', 'feature_name');
		return $model;
	}
        

	public function collectProductFeature($user_group_id=null,$product_group_id=null)
	{
		$condition = 'isActive =  "Y" ';
		if($user_group_id!=null) 
		$condition.= 'AND user_group_id =  '.$user_group_id;
		if($product_group_id!=null) 
		$condition.= 'AND product_group_id =  '.$product_group_id;
		$model = ProductFeature::model()->model()->findAll(array('condition'=>$condition,'order'=>'id'));
		return CHtml::listData($model, 'id', 'feature_name');

	}
}
