<?php

/**
 * This is the model class for table "{{_product_downloadable}}".
 *
 * The followings are the available columns in table '{{_product_downloadable}}':
 * @property integer $id
 * @property string $item_name
 * @property string $isActive
 */
class ProductDownloadable extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ProductDownloadable the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{_product_downloadable}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('item_name', 'required'),
			array('item_name', 'unique'),
			//array('item_name,item_value', 'length', 'max'=>255),
			array('item_name', 'length', 'max'=>255),
			array('isActive,show_in_partner', 'length', 'max'=>1),
				
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, item_name, show_in_partner, isActive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'item_name' => 'Item Name',
			'show_in_partner' => 'Show in Partner',	
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.
        $searchterm = Yii::app()->request->getParam('searchterm');
		if(!empty($searchterm))
		$searchterm = trim(Yii::app()->request->getParam('searchterm'));
		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('item_name',$this->item_name,true);
		$criteria->compare('isActive',$this->isActive,true);
        if(!empty($searchterm))
        {
           $criteria->addCondition('t.item_name like "%'.$searchterm.'%"','AND');
        }
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
			'sort'=>array(
            'defaultOrder'=>'t.id DESC',
       	 	),'pagination'=>false
//			'pagination'=>array('pageSize'=>Yii::app()->params['defaultPageSize'])
		));
	}
	
	//Get Category(s)

	//param group id, returning model

	public function getDownloadableItems($needList=true,$cid=null)
	{
		$condition	=	'isActive =  "Y" ';
		if($cid!=null) 
		$condition	.=	'AND id =  '.$cid;
		$model		=	ProductDownloadable::model()->findAll(array('condition'=>$condition,'order'=>'id'));
		if($needList)
			return CHtml::listData($model, 'id', 'item_name');
		return $model;
	}
        public static function getAllDownloadableItems()
	{
		$condition	=	'isActive =  "Y" ';
		
		$model		=	ProductDownloadable::model()->findAll(array('condition'=>$condition,'order'=>'id'));
			return CHtml::listData($model, 'id', 'item_name');
	}
        
        
        
}