<?php

/**
 * This is the model class for table "{{_product}}".
 *
 * The followings are the available columns in table '{{_product}}':
 * @property integer $id
 * @property string $product_generic_name
 * @property string $product_name
 * @property string $product_image
 * @property integer $main_category_id
 * @property integer $category_id
 * @property integer $sub_category_id
 * @property integer $product_category_id
 * @property integer $product_sub_category_id
 * @property string $isIntoPromotion
 * @property string $rewardPoints
 * @property string $promotionFrom
 * @property string $promotionTo
 * @property integer $specifications
 * @property string $overview
 * @property string $description
 * @property string $created
 * @property string $isActive
 * @property string $isDelete
 */
class Product extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{_product}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
          //  array('product_generic_name, product_name, main_category_id, category_id, sub_category_id, specifications, overview, description,product_image', 'required'),
            array('product_generic_name, product_name, main_category_id, category_id, sub_category_id', 'required'),
            array('main_category_id, category_id, sub_category_id, product_category_id, product_sub_category_id,new_hot_product', 'numerical', 'integerOnly' => true),
            array('product_generic_name, product_name, product_image, rewardPoints', 'length', 'max' => 255),
            array('isIntoPromotion, isActive, isDelete', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, product_generic_name, product_name, product_image, main_category_id, category_id, sub_category_id, product_category_id, product_sub_category_id, isIntoPromotion, rewardPoints, promotionFrom, promotionTo, specifications, overview, description, created, isActive, isDelete', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'maincategory' => array(self::BELONGS_TO, 'MainCategory', 'main_category_id'),
            'category' => array(self::BELONGS_TO, 'Category', 'category_id'),
            'subcategory' => array(self::BELONGS_TO, 'SubCategory', 'sub_category_id'),
            'productcategory' => array(self::BELONGS_TO, 'ProductCategory', 'product_category_id'),
         //   'productCategory' => array(self::BELONGS_TO, 'ProductCategory', 'product_category_id'),
            'productsubcategory' => array(self::BELONGS_TO, 'ProductSubCategory', 'product_sub_category_id'),
            'productfeaturerelation' => array(self::HAS_MANY, 'ProductFeatureRelation', 'product_id'),
            'productdownloadrelation' => array(self::HAS_MANY, 'ProductDownloadableRelation', 'product_id'),
            'productimages' => array(self::HAS_MANY, 'ProductImages', 'product_id'),
            'productMapping' => array(self::HAS_MANY, 'ProductMapping', 'product_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'product_generic_name' => 'Product Generic Name',
            'product_name' => 'Product Name',
            'product_image' => 'Product Image',
            'main_category_id' => 'Main Category',
            'category_id' => 'Category',
            'sub_category_id' => 'Sub Category',
            'product_category_id' => 'Product Category',
            'product_sub_category_id' => 'Product Sub Category',
            'isIntoPromotion' => 'Is Into Promotion',
            'rewardPoints' => 'Reward Points',
            'promotionFrom' => 'Promotion From',
            'promotionTo' => 'Promotion To',
            'specifications' => 'Specifications',
            'overview' => 'Overview',
            'description' => 'Description',
            'created' => 'Created',
            'isActive' => 'Is Active',
            'isDelete' => 'Is Delete',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.
		$search = Yii::app()->request->getParam('searchterm');
        if(!empty($search))
    	$search = trim(Yii::app()->request->getParam('searchterm'));
    	
        $criteria = new CDbCriteria;
        
        $criteria->with = array('maincategory', 'category','subcategory','productcategory','productsubcategory');

        $criteria->compare('id', $this->id);
        $criteria->compare('product_generic_name', $this->product_generic_name, true);
        $criteria->compare('product_name', $this->product_name, true);
        $criteria->compare('product_image', $this->product_image, true);
        $criteria->compare('main_category_id', $this->main_category_id);
        $criteria->compare('category_id', $this->category_id);
        $criteria->compare('sub_category_id', $this->sub_category_id);
        $criteria->compare('product_category_id', $this->product_category_id);
        $criteria->compare('product_sub_category_id', $this->product_sub_category_id);
        $criteria->compare('isIntoPromotion', $this->isIntoPromotion, true);
        $criteria->compare('rewardPoints', $this->rewardPoints, true);
        $criteria->compare('promotionFrom', $this->promotionFrom, true);
        $criteria->compare('promotionTo', $this->promotionTo, true);
        $criteria->compare('specifications', $this->specifications);
        $criteria->compare('overview', $this->overview, true);
        $criteria->compare('description', $this->description, true);
        $criteria->compare('created', $this->created, true);
        $criteria->compare('isActive', $this->isActive, true);
        $criteria->compare('isDelete', $this->isDelete, true);
        
        if (!empty($search)) {
        	$criteria->addCondition('t.product_name like "%' . $search . '%" OR t.product_generic_name like "%' . $search . '%" OR productsubcategory.product_sub_category like "%' . $search . '%" OR maincategory.main_category like "%' . $search . '%" OR category.category like "%' . $search . '%" OR subcategory.sub_category like "%' . $search . '%" OR productcategory.product_category like "%' . $search . '%"', 'AND');
        }

         return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        		'pagination'=>array(
        				'pageSize'=>10,
        				'pageVar'=>'custom-page-selector', //page selector
        		),
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return Product the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }
public static function getAllProducts()
        {
            $condition	=	'isActive =  "Y"';
            $model		=	Product::model()->findAll(array('condition'=>$condition,'order'=>'product_name'));
	    return CHtml::listData($model, 'id', 'product_name');
        }
        
        public function searchProductForSortOrder($product_category_id=0,$product_sub_category_id=0) {
        	// @todo Please modify the following code to remove attributes that should not be searched.
        
        	$criteria = new CDbCriteria;
        	$criteria->with = array('maincategory', 'category','subcategory','productcategory','productsubcategory');
        
        	if (!empty($product_category_id))
        	{
        		$criteria->addCondition('t.product_category_id='.$product_category_id, 'AND');
        	}
        	if (!empty($product_sub_category_id))
        	{
        		$criteria->addCondition('t.product_category_id='.$product_sub_category_id, 'AND');
        	}
        	$criteria->order = 't.sort_order';
        	return new CActiveDataProvider($this, array(
        			'criteria' => $criteria,
        	));
        }
}
