<?php

/**
 * This is the model class for table "{{ptp_product_replacement}}".
 *
 * The followings are the available columns in table '{{ptp_product_replacement}}':
 * @property string $id
 * @property string $terms_and_conditions
 */
class NbdProductReplacement extends CActiveRecord
{

        public $confirm_email;
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{_nbd_product_replacement}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('firstname,lastname,email,company_name,shipping_address,receipt_name', 'required'),
			array('firstname,lastname,email,company_name,shipping_address,receipt_name', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
                        array('verifyCode', 'captcha', 'on'=>'captchaRequired'),
			array('id, firstname, lastname,mobile,email,company_name,shipping_address,mobile,date_of_purchase,receipt_name,registration_date,status', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'firstname' => 'First Name',
                        'lastname' => 'Last Name',
                        'email' => 'Email',
                        'mobile' => 'Mobile',
                        'receipt_name'=>'Receipt Name',
                        'registration_date' => 'Registration Date',
                        'status' => 'Status',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.
		$criteria=new CDbCriteria;
		$criteria->addCondition('status="N"','AND');
		$criteria->compare('id',$this->id,true);
		$criteria->compare('firstname',$this->firstname,true);
		$criteria->compare('lastname',$this->lastname,true);
		$criteria->compare('mobile',$this->mobile,true);
                
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
			'sort'=>array(
                        'defaultOrder'=>'t.id DESC',
       	 	),
			'pagination'=>array('pageSize'=>10)
		));
	}
	
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Country the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}     
	
	
}