<?php

/**
 * This is the model class for table "{{_menu_item}}".
 *
 * The followings are the available columns in table '{{_menu_item}}':
 * @property integer $id
 * @property integer $parent_id
 * @property string $menu_title
 * @property integer $sortOrder
 * @property string $isActive
 *
 * The followings are the available model relations:
 * @property MenuItem $parent
 * @property MenuItem[] $menuItems
 */
class MenuItem extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return MenuItem the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{_menu_item}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('menu_title, sortOrder', 'required'),
			array('parent_id, sortOrder', 'numerical', 'integerOnly'=>true),
			array('parent_id', 'myrule'),
			array('menu_title, href', 'length', 'max'=>255),
                    	array('isLink, isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, parent_id, menu_title, sortOrder, isActive', 'safe', 'on'=>'search'),
		);
	}
	
	public function myrule($attribute,$params)
	{
		if ($this->id	== $this->parent_id)
		  $this->addError($attribute, 'Parent menu and child menu can\'t be same!');
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'parent' => array(self::BELONGS_TO, 'MenuItem', 'parent_id'),
			'menuItems' => array(self::HAS_MANY, 'MenuItem', 'parent_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'parent_id' => 'Parent',
			'menu_title' => 'Menu Title',
			'sortOrder' => 'Sort Order',
			'isActive' => 'Is Active',
                        'isLink'=>'Does menu point to a link',
                        'href'=>'Link'
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.
                $search= Yii::app()->request->getParam('searchterm');
				if(!empty($search))
				$search= trim(Yii::app()->request->getParam('searchterm'));
		$criteria=new CDbCriteria;

		$criteria->with	=	array('parent');
		
		$criteria->compare('t.id',$this->id);
		//$criteria->compare('t.parent_id',43);
		$criteria->compare('t.parent_id',$this->parent_id);
		$criteria->compare('t.menu_title',$this->menu_title,true);
		$criteria->compare('t.sortOrder',$this->sortOrder);
		$criteria->compare('t.isActive',$this->isActive,true);
       if(!empty($search))
        {
                    $criteria->addCondition('t.menu_title like "%'.$search.'%"','AND');
       }		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
			'sort'=>array(
                        'defaultOrder'=>'t.sortOrder DESC',
       	 	),
			'pagination'=>false,
		));
	}
	
	public function getMenu($needList=true,$parentId=0,$onlySubs=false)
	{
		$condition	=	'isActive =  "Y" ';
		if($parentId!=null) 
			$condition	.=	' AND parent_id 	 =  '.$parentId;
		if($onlySubs)
			$condition	.=	' AND parent_id 	 <> 0';
		$model		=	MenuItem::model()->findAll(array('condition'=>$condition,'order'=>'sortOrder'));
		if($needList)
			return CHtml::listData($model, 'id', 'menu_title');
		return $model;
	}
        
       public function getAllMenu()
	{
		$condition	=	'isActive =  "Y" ';
		
		$model		=	MenuItem::model()->findAll(array('condition'=>$condition,'order'=>'sortOrder'));
               return CHtml::listData($model, 'id', 'menu_title');
	} 
        
}