<?php

/**
 * This is the model class for table "{{_front_cms}}".
 *
 * The followings are the available columns in table '{{_front_cms}}':
 * @property integer $id
 * @property string $title
 * @property string $image_name
 * @property integer $sort_order
 * @property string $isActive
 */
class FrontCms extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{_front_cms}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('title, image_name, sort_order, isActive', 'required'),
           // array('link', 'link', 'defaultScheme' => 'http'),
            array('sort_order', 'numerical', 'integerOnly' => true),
            array('title, image_name', 'length', 'max' => 255),
            array('isActive', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, title,link, image_name, sort_order, isActive', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'title' => 'Title',
            'image_name' => 'Image Name',
            'sort_order' => 'Sort Order',
            'isActive' => 'Is Active',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('title', $this->title, true);
        $criteria->compare('image_name', $this->image_name, true);
        $criteria->compare('sort_order', $this->sort_order);
        $criteria->compare('isActive', $this->isActive, true);
        $criteria->order = 'sort_order asc';

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return FrontCms the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
