<?php

/**
 * This is the model class for table "{{_events}}".
 *
 * The followings are the available columns in table '{{_events}}':
 * @property string $id
 * @property string $event_title
 * @property string $event_date
 * @property string $event_time
 * @property string $event_end_date
 * @property string $event_end_time
 * @property string $description
 * @property string $isActive
 */
class Events extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Events the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{_events}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('event_title, event_date, event_time, event_end_date, event_end_time, description', 'required'),
			array('event_title', 'length', 'max'=>255),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, event_title, event_date, event_time, event_end_date, event_end_time, description, isActive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'event_title' => 'Event Title',
			'event_date' => 'Event Start Date',
			'event_time' => 'Event Start Time',
			'event_end_date' => 'Event End Date',
			'event_end_time' => 'Event End Time',
			'description' => 'Description',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);
		$criteria->compare('event_title',$this->event_title,true);
		$criteria->compare('event_date',$this->event_date,true);
		$criteria->compare('event_time',$this->event_time,true);
		$criteria->compare('event_end_date',$this->event_end_date,true);
		$criteria->compare('event_end_time',$this->event_end_time,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('isActive',$this->isActive,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
			'sort'=>array(
            'defaultOrder'=>'t.id DESC',
       	 	),
			'pagination'=>array('pageSize'=>Yii::app()->params['defaultPageSize'])
		));
	}
	
	/* get all active events */
	public function getAllEvents($limit=5)
	{
		$condition	=	'isActive =  "Y"';
		return (Events::model()->findAll(array('condition'=>$condition,'order'=>'event_date','limit'=>$limit)));
	}
}