<?php

/**
 * This is the model class for table "{{_category}}".
 *
 * The followings are the available columns in table '{{_category}}':
 * @property integer $id
 * @property integer $main_category_id
 * @property string $category
 * @property string $description
 * @property string $icon_image
 * @property string $isActive
 */
class Category extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{_category}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('main_category_id, category', 'required'),
            array('main_category_id', 'numerical', 'integerOnly' => true),
            array('category, icon_image,banner', 'length', 'max' => 255),
           array('description', 'length', 'max' =>5000), 
            array('isActive', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, main_category_id, category, description, icon_image,banner, isActive', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'maincategory' => array(self::BELONGS_TO, 'MainCategory', 'main_category_id'),
                // 'division' => array(self::BELONGS_TO, 'Division', 'division_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'main_category_id' => 'Main Category',
            'category' => 'Category',
            'description' => 'Description',
            'icon_image' => 'Icon Image',
            'banner' => 'Banner',
            'isActive' => 'Is Active',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.
        $search = Yii::app()->request->getParam('searchterm');
        if(!empty($search))
        $search = trim(Yii::app()->request->getParam('searchterm'));
        $criteria = new CDbCriteria;
        $criteria->with = array('maincategory');

        $criteria->compare('id', $this->id);
        $criteria->compare('main_category_id', $this->main_category_id);
        $criteria->compare('category', $this->category, true);
        $criteria->compare('description', $this->description, true);
        $criteria->compare('icon_image', $this->icon_image, true);
        //$criteria->compare('isActive', $this->isActive, true);
        if (!empty($search)) {
            $criteria->addCondition('t.category like "%' . $search . '%" OR maincategory.main_category like "%' . $search . '%"', 'AND');
        }
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return Category the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }
//
//    public function getCategory($main_category_id = null, $getAll = false) {
//
//        $condition = 'isActive =  "Y"';
//        if ($main_category_id != null)
//            $condition .= ' AND main_category_id =  ' . $main_category_id;
//
//        $model = Category::model()->findAll(array('condition' => $condition));
//
//        return CHtml::listData($model, 'id', 'category');
//    }

    public static function getCategory($main_category_id = null, $getAll = false) {
        $condition = 'isActive =  "Y"';
        if ($main_category_id != null) {
            $condition .= ' AND main_category_id =  ' . (int) $main_category_id;
            $model = Category::model()->findAll(array('condition' => $condition,'order' => 'category'));
            return CHtml::listData($model, 'id', 'category');
        }
        if ($getAll) {
          $model = Category::model()->findAll(array('condition' => $condition,'order' => 'category'));
            return CHtml::listData($model, 'id', 'category');
        }
        return array();
    }
    
    public static function getCategoryAll() {
        $condition = 'isActive =  "Y"';
        
        
          $model = Category::model()->findAll(array('condition' => $condition,'order' => 'category'));
            return CHtml::listData($model, 'id', 'category');
        
       // return array();
    }
    
    

    public function searchCategoryForSortOrder($main_category_id=0) {
    	// @todo Please modify the following code to remove attributes that should not be searched.
    	$criteria = new CDbCriteria;
    	$criteria->with = array('maincategory');
    	
     	if (!empty($main_category_id)) 
     	{
            $criteria->addCondition('t.main_category_id='.$main_category_id, 'AND');
        }
    	
        $criteria->order = 't.sort_order';
    	return new CActiveDataProvider($this, array(
    			'criteria' => $criteria,
    	));
    }
}
