<?php

class UsersController extends Controller {

    public $title = "User";

    public function accessRules() {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(
                    'Index', 'Create', 'GetList', 'SaveUser', 'DeleteUsers',
                    'SalesMaster', 'GetSalesList', 'Target', 'SaveTarget', 'UploadSignature',
                    'BlockUser', 'UnBlockUser', 'changepassword', 'Updatepassword',
                    'ChangeMypassword','Viewprofile','SaveProfile','LogoUpload','ProfilePhotoUpload','ChangeWallet'
                ),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
       // if (isset(Yii::app()->user->havePermissionOn['user']) || isset(Yii::app()->user->havePermissionOn['admin_user_view']) || Yii::app()->user->authorised_user == 1) {
            $this->render('index');
        //     } else {
        //      throw new CHttpException(401, 'Unauthorized Access');
        // }
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionGetList() {
        $model = new User();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'fullname',
            2 => 'company_email_address',
            3 => 'designation', 
            4 => 'user_type_id',
            5 => 'isConfirmed',
            6 => 'isActive',
            7 => 'isWalletPaswdRequested',
            8 => 'id',
            9 => 'id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.id != 1  ';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
          //  $condition .= " and (fullname LIKE '%" . $searchString . "%' OR user_full_name LIKE '%" . $searchString . "%' OR userGroup.group_name LIKE '%" . $searchString . "%')";
        
         $condition .= " and (fullname LIKE '%" . $searchString . "%' OR company_email_address LIKE '%" . $searchString . "%' OR company_email_address LIKE '%" . $searchString . "%')";     
            
        }
       // $count = $model->with('userGroup')->count(array('condition' => $condition));
      //  $model = $model->with('userGroup')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 'fullname'));
        
         $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $div = '';
             //if (((int) Yii::app()->user->havePermissionOn["admin_user_edit"]) || isset(Yii::app()->user->havePermissionOn['admin_user_edit'])) {
                $div .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'users/create&id=' . $row['id'] . '\',\'Users\',\'lg\')"><i class="fas fa-edit"></i></button>';
                $div .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'users/changepassword&id=' . $row['id'] . '\',\'Update Password\',\'lg\')"><i class="fas fa-key"></i></button>';
            // }
            // if (((int) Yii::app()->user->havePermissionOn["admin_user_delete"]) || isset(Yii::app()->user->havePermissionOn['admin_user_delete'])) {
                if ($row->isActive == 'Y') {
                    $div .= ' <a href ="#" class="btn btn-success btn-xs" onclick="disableuser(' . $row['id'] . ')"><i class="fa fa-toggle-on"></i></a>';
                }
                if ($row->isActive == 'N') {
                    $div .= ' <a href ="#" class="btn btn-danger btn-xs" onclick="enableuser(' . $row['id'] . ')"><i class="fa fa-ban"></i></a>';
                }
            // }
                $send_wallet_div = ' <a href ="#"  onclick="sendwalletpwd(' . $row['id'] . ')"><img src="images/admin/wallet_mail.png" >
</a>';
                $change_wallet_div = ' <a href ="#"  onclick="changewalletpwd(' . $row['id'] . ')"><img src="images/admin/wallet.png" >
</a>';  
            $isConfirmed = $row['isConfirmed'];
            if($isConfirmed == "Y"){
             $isConfirmed ="YES";   
            }else{
               $isConfirmed ="NO"; 
            }
            
            $isActive = $row['isActive'];
            if($isActive == "Y"){
             $isActive ="YES";   
            }else{
               $isActive ="NO"; 
            }
            
             $isWalletPaswdRequested = $row['isWalletPaswdRequested'];
            if($isWalletPaswdRequested == "Y"){
             $isWalletPaswdRequested ="YES";   
            }else{
               $isWalletPaswdRequested ="NO"; 
            }
            $rowData[] = array($m,
                $row['fullname'],
                $row['company_email_address'],
                $row['last_login'],
                isset($row['userType'])?$row['userType']['type']:'',
                $isConfirmed,
                $isActive,
                $isWalletPaswdRequested,
                $send_wallet_div.$change_wallet_div,
                '<div class="btn-wrap text-center">' . $div . '</div>',
                array('id' => $row['id'], 'code' => $row['fullname'])
            );

            $m++;
        }
        $data['draw'] = $draw;
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new User();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('user_form', array('model' => $model), false, false);
    }

    public function actionSaveUser() {
        $model = new User();
        if (isset($_POST['User'])) {
            if ((int) @$_POST['User']['id'] > 0) {

                $id = (int) @$_POST['User']['id'];
                $model = $model->findByPk($id);
            } else {
                $model->scenario = 'add';
                $audit_type = 'CREATED';
            }
            $model->attributes = $_POST['User'];
            if ($model->save()) {
                $jsonData['status'] = 'success';
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionBlockUser() {
        $id = $_POST['id'];
        if ($id > 0) {
            User::model()->updateByPK($id, array('isActive' => "N"));
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }

    public function actionUnBlockUser() {
        $id = $_POST['id'];
        if ($id > 0) {
            User::model()->updateByPK($id, array('isActive' => "Y"));
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }

    public function actionChangepassword() {
        $model = new User();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('change_password', array('model' => $model), false, false);
    }

    public function actionChangeMypassword() {
        
        $model = new User();
        $id = (int) Yii::app()->user->id;
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('change_password', array('model' => $model), false, false);
    }

    public function actionUpdatepassword() {
        $model = new User();
        $id = Yii::app()->user->id;
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        $loginForm = new LoginForm();
        $loginForm->fullname = $model->fullname;
        $loginForm->password = $_POST['user_current_password'];
        ob_clean();
        if ($loginForm->login()) {
            $model->password = $_POST['User']['password'];
            $model->save();
            echo json_encode(["status" => "success"]);
        } else {
            echo json_encode(["status" => "fail"]);
        }
    }

    public function actionViewprofile() {
        $model = new MasCompany();
          $id = Yii::app()->user->master_user_company_id;//Yii::app()->user->id; 
            $model = $model->findByPk($id);
            if(empty($model))
            {
                $model = new MasCompany();
            }
          
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('profile', array('model' => $model), false, false);
    }

    public function actionSaveProfile() {
        $model = new MasCompany();
        if (isset($_POST['MasCompany'])) {
            if ((int) @$_POST['MasCompany']['id'] > 0) {

                $id = (int) @$_POST['MasCompany']['id'];
                $model = $model->findByPk($id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
                $model->scenario = 'add';
                $audit_type = 'CREATED';
            }
            $model->attributes = $_POST['MasCompany'];
             if ($model->save()) {
                $jsonData['status'] = 'success';
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionLogoUpload($folder = null, $filename = null)
    {
        Yii::import("ext.EAjaxUpload.qqFileUploader");
        $field_id = "";
        if (isset($_GET['field_id'])) {
            $field_id = Yii::app()->request->getParam('field_id');
        }
        if (empty($filename)) {
            $filename = 'Documents_' . date('YmdHis');
        }
        $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';

        // make the directory to store the pic:
        if (!is_dir($folder)) {
            mkdir($folder, 0777, TRUE);
        }

        //$allowedExtensions = array("csv"); 
        $allowedExtensions = array("png", "jpg", "jpeg", "gif");
        $sizeLimit =  20 * 1024 * 1024;

        
        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        $result = $uploader->handleUpload($folder, FALSE, $filename);
        $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);
        $result['field_id'] = $field_id;
        $return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);
        echo $return; // it's array
    }
    
       public function actionProfilePhotoUpload($folder = null, $filename = null)
    {
        Yii::import("ext.EAjaxUpload.qqFileUploader");
        $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';
        // make the directory to store the pic:
        if (!is_dir($folder)) {
            mkdir($folder, 0777, TRUE);
        }
        //$allowedExtensions = array("csv"); 
        $allowedExtensions = array("png", "jpg", "jpeg", "gif");
        $sizeLimit =  2 * 1024 * 1024;
        
        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        $result = $uploader->handleUpload($folder, FALSE, $filename);
        $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);
        $result['field_id'] = $field_id;
        $return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);
        echo $return; // it's array
    }
    
   public function actionChangeWallet($id,$mail=false)
	{
			$model=$this->loadModel((int)$id);
			$model->wallet_password	= $this->get_random_string('ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqestuvwxyz1234567890',8);
			$model->isWalletPaswdRequested	=	'N';
			if($mail)
			{
				$mailContent = array();
				$mailContent['fullname'] = $model->fullname; 
				$mailContent['walletpassword'] = $model->wallet_password;
				
				$message = new YiiMailMessage;
				$message->view = 'emailWalletPassword';
				
				$message->setBody(array('mailContent'=>$mailContent), 'text/html');
				$message->subject = 'Dlink Wallet Password (New) ';
				
				//$message->from	=	Yii::app()->params['adminEmail'];
				$message->from	=	'noreply@me.dlink.com';
				$message->addTo($model->company_email_address);
				Yii::app()->mail->send($message);
			}
			$model->wallet_password	=	md5($model->wallet_password);
			$model->save(false);
	}
	 
    
    
    
}
