<?php
class ProductfeatureController extends Controller {
    public $title = "Product Feature";
    public function accessRules() {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(
                    'Index', 'Create', 'GetList', 'Save', 'DeleteFeature',
                    'BlockFeature', 'UnBlockFeature' 
                 ),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }
    public function actionIndex() {
       // if (isset(Yii::app()->Category->havePermissionOn['user']) || isset(Yii::app()->user->havePermissionOn['admin_user_view']) || Yii::app()->user->authorised_user == 1) {
            $this->render('index');
        //     } else {
        //      throw new CHttpException(401, 'Unauthorized Access');
        // }
    }
    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
    public function actionGetList() {
        $model = new ProductFeature();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'feature_name',
            2 => 'isActive',
            3 => 'id',
            
         );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1 ';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and (feature_name LIKE '%" . $searchString . "%'  )";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $div = '';
            // if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["admin_user_edit"]) || isset(Yii::app()->user->havePermissionOn['admin_user_edit'])) {
                $div .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'productfeature/create&id=' . $row['id'] . '\',\' Product Feature\',\'sm\')"><i class="fas fa-edit"></i></button>';
                $div .= ' <a href ="#" class="btn btn-danger btn-xs" onclick="deletefeature(' . $row['id'] . ')"><i class="fa fa-trash-o"></i></a>';
              
                // }
                $active = '';
           //  if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["admin_user_delete"]) || isset(Yii::app()->user->havePermissionOn['admin_user_delete'])) {
                if ($row->isActive == 'Y') {
                    $active .= ' <a href ="#"  onclick="disablefeature(' . $row['id'] . ')"><img src="/images/admin/active.png" /></a>';
                }
                if ($row->isActive == 'N') {
                    $active .= ' <a href ="#"  onclick="enablefeature(' . $row['id'] . ')"><img src="/images/admin/inactive.png" /></a>';
                }
            // }
            $rowData[] = array(
                $m,
                $row->feature_name,
                $active,
                '<div class="btn-wrap text-center">' . $div . '</div>',
                array('id' => $row['id'], 'code' => $row['feature_name'])
            );
            $m++;
        }
        $data['draw'] = $draw;
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionCreate() {
        $model = new ProductFeature();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create', array('model' => $model), false, false);
    }
    public function actionSave() {
        $model = new ProductFeature();
        if (isset($_POST['ProductFeature'])) {
            if ((int) @$_POST['ProductFeature']['id'] > 0) {
                $id = (int) @$_POST['ProductFeature']['id'];
                $model = $model->findByPk($id);
             } else {
                 $model->scenario = 'add';
                $audit_type = 'CREATED';
            }
            $model->attributes = $_POST['ProductFeature'];
            if ($model->save()) {
                $jsonData['status'] = 'success';
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionDeleteFeature() {
        $id = $_POST['id'];
        if ($id > 0) {
            ProductFeature::model()->deleteByPk($id);
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }
    public function actionBlockFeature() {
        $id = $_POST['id'];
        if ($id > 0) {
            ProductFeature::model()->updateByPK($id, array('isActive' => "N"));
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }
    public function actionUnBlockFeature() {
        $id = $_POST['id'];
        if ($id > 0) {
            ProductFeature::model()->updateByPK($id, array('isActive' => "Y"));
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }
     
     
}
