<?php
class ProductcategoryfeatureController extends Controller {
    public $title = "Product Category Feature";
    public function accessRules() {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(
                    'Index', 'Create', 'GetList', 'Save', 'DeleteFeature',
                    'BlockFeature', 'UnBlockFeature' 
                 ),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }
    public function actionIndex() {
       // if (isset(Yii::app()->Category->havePermissionOn['user']) || isset(Yii::app()->user->havePermissionOn['admin_user_view']) || Yii::app()->user->authorised_user == 1) {
            $this->render('index');
        //     } else {
        //      throw new CHttpException(401, 'Unauthorized Access');
        // }
    }
    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
    public function actionGetList() {
        $model = new ProductCategoryFeature();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'category_id',
            2 => 'feature',
            3 => 'sort_order',
            4 => 'id'
            
         );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1 ';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and (feature LIKE '%" . $searchString . "%'  )";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $div = '';
            // if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["admin_user_edit"]) || isset(Yii::app()->user->havePermissionOn['admin_user_edit'])) {
                $div .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'productcategoryfeature/create&id=' . $row['id'] . '\',\' Product Category Feature\',\'sm\')"><i class="fas fa-edit"></i></button>';
                $div .= ' <a href ="#" class="btn btn-danger btn-xs" onclick="deletefeature(' . $row['id'] . ')"><i class="fa fa-trash-o"></i></a>';
              
                // }
             
            $rowData[] = array(
                $m,
                $row->category->category,
                $row['feature'],
                $row['sort_order'],
                '<div class="btn-wrap text-center">' . $div . '</div>',
                array('id' => $row['id'], 'code' => $row['feature'])
            );
            $m++;
        }
        $data['draw'] = $draw;
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionCreate() {
        $model = new ProductCategoryFeature();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create', array('model' => $model), false, false);
    }
    public function actionSave() {
        $model = new ProductCategoryFeature();
        $other = array();
        $valid = true;

        if (isset($_POST['ProductCategoryFeature'])) {
            if ((int) @$_POST['ProductCategoryFeature']['id'] > 0) {
                $id = (int) @$_POST['ProductCategoryFeature']['id'];
                $model = $model->findByPk($id);
                $model->scenario = 'edit';
             } else {
                 $model->scenario = 'add';
                $audit_type = 'CREATED';
            }
            $model->attributes = $_POST['ProductCategoryFeature'];
            $cat_id= trim((int) $_POST['ProductCategoryFeature']['category_id']);
            //$subcat_id= trim( (int)$_POST['ProductCategoryFeature']['subcat_id']);
            $feature= trim($_POST['ProductCategoryFeature']['feature']);
              $modelCategory = new ProductCategoryFeature();
              if($model->scenario == 'add')
              {
                $condition ='category_id="' . $cat_id . '"  
                  AND  feature="'.$feature.'" AND isActive="Y"';
              }
              else
              {
                $condition ='category_id="' . $cat_id . '"   
                AND  feature="'.$feature.'" AND isActive="Y" AND id!='.$model->id;
              }
               $modelCount = $modelCategory->count(array('condition' => $condition));
              if ($modelCount > 0) {
              $other[] =' This Feature  Already Taken';// $cat_name.
              $valid = false;
              }
              $valid = $valid && $model->validate();
            if ($model->save()) {
                $jsonData['status'] = 'success';
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionDeleteFeature() {
        $id = $_POST['id'];
        if ($id > 0) {
            ProductCategoryFeature::model()->deleteByPk($id);
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }
    public function actionBlockFeature() {
        $id = $_POST['id'];
        if ($id > 0) {
            ProductCategoryFeature::model()->updateByPK($id, array('isActive' => "N"));
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }
    public function actionUnBlockFeature() {
        $id = $_POST['id'];
        if ($id > 0) {
            ProductCategoryFeature::model()->updateByPK($id, array('isActive' => "Y"));
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }
     
     
}
