<?php
class ProductcategoryController extends Controller {
    public $title = "Product Category";
    public function accessRules() {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(
                    'Index', 'Create', 'GetList', 'Save', 'DeleteCategory',
                    'BlockCategory', 'UnBlockCategory', 'Upload' ,'GetCategory','GetSubCategory','uploadImage'
                 ),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }
    public function actionIndex() {
       // if (isset(Yii::app()->Category->havePermissionOn['user']) || isset(Yii::app()->user->havePermissionOn['admin_user_view']) || Yii::app()->user->authorised_user == 1) {
            $this->render('index');
        //     } else {
        //      throw new CHttpException(401, 'Unauthorized Access');
        // }
    }
    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
    public function actionGetList() {
        $model = new ProductCategory();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'main_category_id',
            2 => 'category_id',
            3 => 'sub_category_id',
            4 => 'product_category',
            5 => 'image',
            6 => 'id'
         );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1 ';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and (product_category LIKE '%" . $searchString . "%'  )";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $div = '';
            // if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["admin_user_edit"]) || isset(Yii::app()->user->havePermissionOn['admin_user_edit'])) {
                $div .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'productcategory/create&id=' . $row['id'] . '\',\' Sub Category\',\'sm\')"><i class="fas fa-edit"></i></button>';
                $div .= ' <a href ="#" class="btn btn-danger btn-xs" onclick="deletecategory(' . $row['id'] . ')"><i class="fa fa-trash-o"></i></a>';
              
                // }
           //  if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["admin_user_delete"]) || isset(Yii::app()->user->havePermissionOn['admin_user_delete'])) {
                // if ($row->isActive == 'Y') {
                //     $div .= ' <a href ="#" class="btn btn-success btn-xs" onclick="disablecategory(' . $row['id'] . ')"><i class="fa fa-toggle-on"></i></a>';
                // }
                // if ($row->isActive == 'N') {
                //     $div .= ' <a href ="#" class="btn btn-danger btn-xs" onclick="enablecategory(' . $row['id'] . ')"><i class="fa fa-ban"></i></a>';
                // }
            // }
            $rowData[] = array(
                $m,
                $row->maincategory->main_category,
                $row->category->category,
                $row->subcategory->sub_category,
                $row['product_category'],
               // '<img src="/images/group/'.$row['image'].'" height="70" width="50" />',
               !empty($row['image']) ? '<img src="/images/group/'.$row['image'].'" height="70" width="50" />' : '',
                '<div class="btn-wrap text-center">' . $div . '</div>',
                array('id' => $row['id'], 'code' => $row['product_category'])
            );
            $m++;
        }
        $data['draw'] = $draw;
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionCreate() {
        $model = new ProductCategory();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create', array('model' => $model), false, false);
    }
    public function actionSave() {
        $model = new ProductCategory();
        $other = array();
        $valid = true;

        if (isset($_POST['ProductCategory'])) {
            if ((int) @$_POST['ProductCategory']['id'] > 0) {
                $id = (int) @$_POST['ProductCategory']['id'];
                $model = $model->findByPk($id);
                $model->scenario ='edit';
             } else {
                 $model->scenario = 'add';
                $audit_type = 'CREATED';
            }
            $model->attributes = $_POST['ProductCategory'];
            $model->image =$_POST['ProductCategory']['image'];
            $model->banner =$_POST['ProductCategory']['banner'];
            
            $maincat_id= trim($_POST['ProductCategory']['main_category_id']);
            $cat_id= trim($_POST['ProductCategory']['category_id']);
            $subcat_id= trim($_POST['ProductCategory']['sub_category_id']);
            $cat_name= trim($_POST['ProductCategory']['product_category']);
              $modelCategory = new ProductCategory();
              if($model->scenario == 'add')
              {
                $condition ='main_category_id="' . $maincat_id . '" AND category_id="'.$cat_id.'" 
                AND sub_category_id="'.$subcat_id.'" AND  product_category="'.$cat_name.'" AND isActive="Y"';
              }
              else
              {
                $condition ='main_category_id="' . $maincat_id . '" AND category_id="'.$cat_id.'" 
                AND sub_category_id="'.$subcat_id.'" AND  product_category="'.$cat_name.'" AND isActive="Y" AND id!='.$model->id;
              }
               $modelCount = $modelCategory->count(array('condition' => $condition));
              if ($modelCount > 0) {
              $other[] = $cat_name.' Name Already Taken';
              $valid = false;
              }
              $valid = $valid && $model->validate();
            if ($valid) {
                $model->save();
                $jsonData['status'] = 'success';
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error1, $other));
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionDeleteCategory() {
        $id = $_POST['id'];
        if ($id > 0) {
            ProductCategory::model()->deleteByPk($id);
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }
    public function actionUnBlockCategory() {
        $id = $_POST['id'];
        if ($id > 0) {
            ProductCategory::model()->updateByPK($id, array('isActive' => "Y"));
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }
    public function actionUpload($folder = null){
        Yii::import("ext.EAjaxUpload.qqFileUploader");
    	$folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';
    	// make the directory to store the pic:
    	if (!is_dir($folder)) {
    		mkdir($folder, 0777, TRUE);
    	}
    	$allowedExtensions = array("jpg", "jpeg", "gif","png"); //array("jpg","jpeg","gif","exe","mov" and etc...
    	$sizeLimit = 8 * 1024 * 1024; // maximum file size in bytes
    	$uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
    	$result = $uploader->handleUpload($folder);
    	$result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);
    	$result['field_id'] = $field_id;
    	$return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);
    	$fileName = $result['filename']; //GETTING FILE NAME
    	$imagename	=	Yii::app()->basePath.'/../uploads/productimages/'.$fileName;
    	$imagename_thumb	=	Yii::app()->basePath.'/../uploads/productimages/thumbs/'.$fileName;
    	Yii::import("ext.EPhpThumb.EPhpThumb");
    	$thumb=new EPhpThumb();
    	$thumb->init(); //this is needed
    	//chain functions
    	$thumb->create($imagename)->resize(100,100)->save($imagename_thumb);
    	echo $return; // it's array
    }
    public function actionGetCategory() {
        $id = Yii::app()->request->getparam('id');
        $dropdown=array();
        $model = new ProductCategory(); 
        if($id > 0)
        {
         
        $modelCategory = Category::model()->findall(array('condition'=>'main_category_id="'.$id.'"'));
         
        foreach ($modelCategory as $category_item) {
              $dropdown[$category_item['id']] = $category_item['category'];
            
        }
         }
         $category = CHtml::activedropDownList($model,'category_id', $dropdown, array('prompt'=>'--Select--','class' => 'tooltipster', 'data-label' => 'Category<span style="color:red;">*<span>','onchange' => 'onChangeSubCategory(this.value)'));
         
        $jsonData['category'] = $category;
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }
    public function actionGetSubCategory() {
        $id = Yii::app()->request->getparam('id');
        $main_id = Yii::app()->request->getparam('main_id');
        $dropdown=array();
        $model = new ProductCategory(); 
        if($id > 0)
        {
            $modelCategory = SubCategory::model()->findall(array('condition'=>' category_id="'.$id.'"'));
         
            foreach ($modelCategory as $category_item) {
                  $dropdown[$category_item['id']] = $category_item['sub_category'];
                
            }
         }
         $category = CHtml::activedropDownList($model,'sub_category_id', $dropdown, array('prompt'=>'--Select--','class' => 'tooltipster', 'data-label' => 'Sub Category<span style="color:red;">*<span>'));
         
        $jsonData['category'] = $category;
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }


    public function actionuploadImage($folder = null, $filename = null) {
        Yii::import("ext.EAjaxUpload.qqFileUploader");
        $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';
        // make the directory to store the pic:
        if (!is_dir($folder)) {
            mkdir($folder, 0777, TRUE);
        }
        //$allowedExtensions = array("csv");
        $allowedExtensions = array("jpg","jpeg","gif","exe","mov","pdf","doc","png","zip","bin","hid","tar","rar");
        $sizeLimit = 2 * 1024 * 1024;

        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        $result = $uploader->handleUpload($folder, FALSE, $filename);
        $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);
        //$result['field_id'] = $field_id;
        $return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);
        echo $return; // it's array
    }
     
}
