<?php

class ProductController extends Controller {

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = 'layout';

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
            'postOnly + delete', // we only allow deletion via POST request
        );
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules() {
        return array(
            /* array('allow', // allow all users to perform 'index' and 'view' actions
              'actions' => array('login', 'error', 'logout', 'test', 'recover'),
              'users' => array('*'),
              ), */
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('GetList', 'index','Create','SaveProduct','ProductImageUpload','Upload','Removeitems','DeleteProducts','Removefeaturs'),
                'expression' => '$user->isMember()'
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id) {
        $this->render('view', array(
            'model' => $this->loadModel($id),
        ));
    }

    
    public function actionIndex() {
       
        $this->render('index');
    }

    
    public function actionGetList() {
        $model = new Product();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 't.product_generic_name',
            2 => 't.product_name',
            3 => 't.category_id',
            4 => 't.product_category_id',
            5 => 't.sub_category_id',
            6 => 't.product_sub_category_id',
            7 => 't.id',
            8 => 't.id',
             
         );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1 ';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and (t.product_name LIKE '%" . $searchString . "%' OR t.product_generic_name LIKE '%" . $searchString . "%' OR category.category LIKE '%" . $searchString . "%' OR subcategory.sub_category LIKE '%" . $searchString . "%' OR productcategory.product_category LIKE '%" . $searchString . "%' OR productsubcategory.product_sub_category LIKE '%" . $searchString . "%')";
        }
        
        
        $count = $model->with('category','subcategory','productcategory','productsubcategory')->count(array('condition' => $condition));
        $model = $model->with('category','subcategory','productcategory','productsubcategory')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $div = '';
            // if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["admin_user_edit"]) || isset(Yii::app()->user->havePermissionOn['admin_user_edit'])) {
                $div .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'product/create&id=' . $row['id'] . '\',\' Product \',\'lg\')"><i class="fas fa-edit"></i></button>';
                $div .= ' <a href ="#" class="btn btn-danger btn-xs" onclick="DeleteProducts(' . $row['id'] . ')"><i class="fa fa-trash-o"></i></a>';
                // }
             
            $rowData[] = array(
                 $m,
                 $row->product_generic_name,
                 $row->product_name,
                 $row->maincategory->main_category,
                 $row->category->category,
                 (isset($row->subcategory))?$row->subcategory->sub_category:"",
                 (isset($row->productcategory))?$row->productcategory->product_category:"",
                 (isset($row->productsubcategory))?$row->productsubcategory->product_sub_category:"",
                 '<div class="btn-wrap text-center">' . $div . '</div>',
                array('id' => $row['id'], 'code' => $row->product_name)
            );
            $m++;
        }
        $data['draw'] = $draw;
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    
    
    public function actionCreate() {
        $model = new Product();
        $id = (int) Yii::app()->request->getParam('id');
        
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        $modelproductfeature = ProductFeatureRelation::model()->findAll(array('condition' => 'product_id=' . $id));
            if (empty($modelproductfeature)) {
                $modelproductfeature = array(new ProductFeatureRelation());
            }
            $modelproductdownload = ProductDownloadableRelation::model()->findAll(array('condition' => 'product_id=' . $id));
            if (empty($modelproductdownload)) {
                $modelproductdownload = array(new ProductDownloadableRelation());
            }
        
            $product_images = ProductImages::model()->findAll(array('condition' => 'product_id=' . $id));
            
            
        
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('create', array('model' => $model ,'modelproductfeature' => $modelproductfeature,'modelproductdownload' => $modelproductdownload,'product_images' => $product_images));
    }
    
    
    
    
    
   public function actionSaveProduct()
    {
        $model = new Product();
        $valid=true;
        if (isset($_POST['Product'])) {
            
            if (isset($_POST['product_image'])) {
             $arr_product_images = $_POST['product_image'];
            }
             //$arr_product_images = explode(",",$product_image_name);
            //print_r($product_image_name);exit;
            
            if ((int)$_POST['Product']['id'] > 0) {
                $id = $_POST['Product']['id'];
                $model = $model->findByPk($id);
                
            } else {
               
                $flag = 1;
            }
            $validate = TRUE;
            
            $model->attributes = $_POST['Product'];
            $model->specifications = $_POST['specifications'];
            $model->overview = $_POST['overview'];
            $model->description = $_POST['description'];
             

            $validate = $model->validate();

            
            $product_images = array();
            if (isset($_POST['product_image'])) {
                $product_images = $_POST['product_image'];
                $model->product_image = $product_images[0];
                array_splice($product_images, 0, 1);
            }
            
            if (isset($_POST['product_image1'])) {
                $product_images1 = $_POST['product_image1'];
                $model->product_hot_image = $product_images1[0];
            }
            $new_sort_order  = 0;

            if((int)$_POST['Product']['product_sub_category_id'] > 0)
            {
            	$SQL = "SELECT MAX(sort_order) AS max_sort_order FROM ptp_product WHERE product_sub_category_id=".(int)$_POST['Product']['product_sub_category_id']." AND  sub_category_id=".(int)$_POST['Product']['sub_category_id'];
            	$arr_sort_order = Yii::app()->db->createCommand($SQL)->queryAll();
            	$max_sort_order = $arr_sort_order[0]['max_sort_order'];

            	$new_sort_order = $max_sort_order+1;
            }
            else if((int) $_POST['Product']['product_category_id'] > 0)
            {
            	$SQL = "SELECT MAX(sort_order) AS max_sort_order FROM ptp_product WHERE product_category_id=".(int)$_POST['Product']['product_category_id']." AND  sub_category_id=".(int)$_POST['Product']['sub_category_id'];
            	$arr_sort_order = Yii::app()->db->createCommand($SQL)->queryAll();
            	$max_sort_order = $arr_sort_order[0]['max_sort_order'];

            	$new_sort_order = $max_sort_order+1;
            }
            else if((int)$_POST['Product']['sub_category_id'] > 0)
            {
            	$SQL = "SELECT MAX(sort_order) AS max_sort_order FROM ptp_product WHERE sub_category_id=".(int)$_POST['Product']['sub_category_id'];
            	$arr_sort_order = Yii::app()->db->createCommand($SQL)->queryAll();
            	$max_sort_order = $arr_sort_order[0]['max_sort_order'];

            	$new_sort_order = $max_sort_order+1;
            }


            $model->sort_order = $new_sort_order;
            
            
            
            
            
            if (is_array($_POST['ProductFeatureRelation'])) {
                foreach ($_POST['ProductFeatureRelation'] as $i => $items) {
                        if ($items['id'] > 0) {
                            $modelFeatureRelation[$i] = ProductFeatureRelation::model()->findByPK($items['id']);
                        } else {
                            $modelFeatureRelation[$i] = new ProductFeatureRelation();
                        }
                        $modelFeatureRelation[$i]->attributes = $items;
                        $modelFeatureRelation[$i]->feature_id  = $items['feature_id'];
                        $modelFeatureRelation[$i]->feature_value = $items['feature_value'];
                       
                       
                        $validate = $modelFeatureRelation[$i]->validate() && $validate;
                }
            }      
            $p = 0;
            if (is_array($_POST['ProductDownloadableRelation'])) {

                foreach ($_POST['ProductDownloadableRelation'] as $i => $item) {
                    if ((int)$item['id'] > 0) {
                        $modelProductDownloadable[$p] = ProductDownloadableRelation::model()->findByPk((int)$item['id']);
                    } else {
                        $modelProductDownloadable[$p] = new ProductDownloadableRelation;
                    }
                     //  echo $item['upload_file_name'];exit;
                    $modelProductDownloadable[$p]->attributes = $_POST['ProductDownloadableRelation'][$i];
                    $modelProductDownloadable[$p]->item_id = $item['item_id'];
                    $modelProductDownloadable[$p]->item_value = $item['item_value'];
                    //$modelProductDownloadable[$p]->files_available = $item['upload_file_name'];
                    
                    
                   // $validate = $modelJobSheet[$p]->validate();
                    $p++;
                }
            }

            if ($validate && $valid) {
                $model->save();
                
                if(!empty($arr_product_images)){
                    foreach ($arr_product_images as $product_image_name) {
                        // Check if image already exists for the product
                        $existing = ProductImages::model()->find('product_id=:pid AND product_image=:pimg', array(
                            ':pid' => $model->id,
                            ':pimg' => $product_image_name,
                        ));
                        if (!$existing) {
                            $modelProductImage = new ProductImages();
                            $modelProductImage->product_id = $model->id;
                            $modelProductImage->product_image = $product_image_name;
                            $modelProductImage->isActive = 'Y';
                            $modelProductImage->save();
                        }
                    }
                }
                
                
                
                
               if (!empty($modelFeatureRelation)) {
                    foreach ($modelFeatureRelation as $eachFeatureRelation) {
                        $eachFeatureRelation->product_id = $model->id;
                        $eachFeatureRelation->save();
                    }
                }
              if (!empty($modelProductDownloadable)) {
                    foreach ($modelProductDownloadable as $eachDownloadable) {
                        $eachDownloadable->product_id = $model->id;
                        $eachDownloadable->save();
                    }
                }
                
             $jsonData['status'] = 'success';
            $jsonData['id'] = $model->id;//$_POST['WsProject']['id'];
           // $WsProject = WsProject::model()->findByPK($_POST['WsProject']['id']);
            $jsonData['product_name'] = $model->product_name;//$WsProject->project_name;
            echo CJSON::encode($jsonData);
                
            } else {


                $error7=$error8=$error9=$error10=$error11=$error12=$error13=$error14=array();
           // $error7 = json_decode(CActiveForm::validateTabular($modelinduction, '', false), true);
           /* $error8 = json_decode(CActiveForm::validateTabular($modeldailyschedule, '', false), true);
            $error9 = json_decode(CActiveForm::validateTabular($modelrework, '', false), true);
            $error10 = json_decode(CActiveForm::validateTabular($modelequipments, '', false), true);
            $error11 = json_decode(CActiveForm::validateTabular($modelMemos, '', false), true);
            $error12 = json_decode(CActiveForm::validateTabular($modelExpense, '', false), true);
            $error13 = json_decode(CActiveForm::validateTabular($modelActivities, '', false), true);
             $error14 = json_decode(CActiveForm::validateTabular($model_phase_activity, '', false), true);
             */

                $error = json_decode(CActiveForm::validate($model, '', false), true);
                $error1 = array();
                if (!empty($modelFeatureRelation)) {

                    $error1 = json_decode(CActiveForm::validateTabular($modelFeatureRelation, '', false), true);
                }
                $error3 = array();
                if (!empty($modelFeatureRelation)) {

                    $error3 = json_decode(CActiveForm::validate($modelFeatureRelation, '', false), true);
                }
                $error = CJSON::encode(array_merge_recursive($error, $error1, $error3));
                if ($error != '[]')
                    echo $error;
            }
        }
    } 
    
    
    
    public function actionProductImageUpload($folder = null, $filename = null, $field_id= null) {
        Yii::import("ext.EAjaxUpload.qqFileUploader");
        $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';
        // make the directory to store the pic:
        if (!is_dir($folder)) {
            mkdir($folder, 0777, TRUE);
        }
        //$allowedExtensions = array("csv");
        $allowedExtensions = array("png", "jpg", "jpeg", "gif");
        $sizeLimit = 2 * 1024 * 1024;

        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        $result = $uploader->handleUpload($folder, FALSE, $filename);
        $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);
        $result['field_id'] = $field_id;
        $return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);
        echo $return; // it's array
    }
    
    public function actionUpload($folder = null, $filename = null, $field_id=null) {
        Yii::import("ext.EAjaxUpload.qqFileUploader");
        $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';
        // make the directory to store the pic:
        if (!is_dir($folder)) {
            mkdir($folder, 0777, TRUE);
        }
        //$allowedExtensions = array("csv");
        $allowedExtensions = array("jpg","jpeg","gif","exe","mov","pdf","doc","png","zip","bin","hid","tar","rar");
        $sizeLimit = 2 * 1024 * 1024;

        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        $result = $uploader->handleUpload($folder, FALSE, $filename);
        $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);
        $result['field_id'] = $field_id;
        $return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);
        echo $return; // it's array
    }


    public function actionRemoveitems()
    {
    
        $id = (int) Yii::app()->request->getParam('id');
        
        // Initialize an array to store the response
        $response = array();
        
        // Check if the ID is valid
        if ($id > 0) {
            // Find the model by primary key (ID)
            $modelProductDownloadable = ProductDownloadableRelation::model()->findByPk($id);
        
            // Check if the model exists
            if ($modelProductDownloadable) {
                // Delete the model (record) from the database
                if ($modelProductDownloadable->delete()) {
                    // Set the response as success
                    $response['status'] = 'success';
                    $response['message'] = 'The item has been successfully deleted.';
                } else {
                    // Set the response as failure
                    $response['status'] = 'error';
                    $response['message'] = 'There was an error deleting the item.';
                }
            } else {
                // Handle case if the model was not found
                $response['status'] = 'error';
                $response['message'] = 'The item you are trying to delete does not exist.';
            }
        } else {
            // Handle case if invalid ID is provided
            $response['status'] = 'error';
            $response['message'] = 'Invalid ID.';
        }
        
        // Output the response as JSON
        echo CJSON::encode($response);
    
      
        
    }

    // public function actionDeleteProducts()
    // {
    //     $id = (int) Yii::app()->request->getParam('id');   
    //     if (isset($id)) {
    //         $id = $_POST['id'];

    //         // Find the product model by ID
    //         $product = Product::model()->findByPk($id);

    //         // If the product exists, delete it
    //         if ($product !== null) {
    //             $product->delete();

    //             // Return success response
    //             echo json_encode(['status' => 'success']);
    //         } else {
    //             // Product not found
    //             echo json_encode(['status' => 'error', 'message' => 'Product not found']);
    //         }
    //     } else {
    //         echo json_encode(['status' => 'error', 'message' => 'Invalid ID']);
    //     }

    // }


    public function actionRemovefeaturs()
    {
          $id = $_POST['id'];
            if ($id > 0) {
                ProductFeatureRelation::model()->deleteByPk($id);
                $status['status'] = 'success';
            } else {
                $status['status'] = 'error';
            }
            echo CJSON::encode($status);
    
    }
        public function actionDeleteProducts() {
        $id = $_POST['id'];
        if ($id > 0) {
            Product::model()->deleteByPk($id);
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }
}
