<?php

class NewsController extends Controller {

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = 'layout';

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
            'postOnly + delete', // we only allow deletion via POST request
        );
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules() {
        return array(
            /* array('allow', // allow all users to perform 'index' and 'view' actions
              'actions' => array('login', 'error', 'logout', 'test', 'recover'),
              'users' => array('*'),
              ), */
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('GetList', 'index','Create','Save','ProfilePhotoUpload','Delete','DownloadEmails'),
                'expression' => '$user->isMember()'
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id) {
        $this->render('view', array(
            'model' => $this->loadModel($id),
        ));
    }

    
    public function actionIndex() {
       
        $this->render('index');
    }

    
   public function actionGetList() {
        $model = new News();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 't.title_of_news',
            2 => 't.date',
            3 => 't.id',
             
         );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1 ';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and (t.title_of_news LIKE '%" . $searchString . "%'  )";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $div = '';
            // if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["admin_user_edit"]) || isset(Yii::app()->user->havePermissionOn['admin_user_edit'])) {
                $div .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'news/create&id=' . $row['id'] . '\',\' news \',\'lg\')"><i class="fas fa-edit"></i></button>';
                   $div .= ' <a href ="#" class="btn btn-danger btn-xs" onclick="deletenews(' . $row['id'] . ')"><i class="fa fa-trash-o"></i></a>';

                // }
            $newsdate = date('d-m-Y', strtotime($row->date));       
            $rowData[] = array(
                 $m,
                 $row->title_of_news,
                 $newsdate,
                 
                 '<div class="btn-wrap text-center">' . $div . '</div>',
                array('id' => $row['id'], 'code' => $row->title_of_news)
            );
            $m++;
        }
        $data['draw'] = $draw;
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    
    
    
    public function actionCreate() {
        $model = new News();
        $id = (int) Yii::app()->request->getParam('id');
        
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('create', array('model' => $model));
    }
    
    
    
    
    
   public function actionSave()
    {
        $model = new News();
        $valid=true;
        if (isset($_POST['News'])) {
            if ((int)$_POST['News']['id'] > 0) {
                $id = $_POST['News']['id'];
                $model = $model->findByPk($id);
                
            } else {
               
                $flag = 1;
            }
            $validate = TRUE;
            
            $model->attributes = $_POST['News'];
            $model->content = $_POST['content'];

            $validate = $model->validate();

            if ($validate) {
                $model->save();
                $jsonData['status'] = 'success';
            $jsonData['id'] = $model->id;//$_POST['WsProject']['id'];
           // $WsProject = WsProject::model()->findByPK($_POST['WsProject']['id']);
            echo CJSON::encode($jsonData);
                
            } else {



                $error = json_decode(CActiveForm::validate($model, '', false), true);
               
                $error = CJSON::encode(array_merge_recursive($error));
                if ($error != '[]')
                    echo $error;
            }
        }
    } 
    
    
    
    public function actionProfilePhotoUpload($folder = null, $filename = null) {
        Yii::import("ext.EAjaxUpload.qqFileUploader");
        $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';
        // make the directory to store the pic:
        if (!is_dir($folder)) {
            mkdir($folder, 0777, TRUE);
        }
        //$allowedExtensions = array("csv");
        $allowedExtensions = array("png", "jpg", "jpeg", "gif");
        $sizeLimit = 2 * 1024 * 1024;

        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        $result = $uploader->handleUpload($folder, FALSE, $filename);
        $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);
        $result['field_id'] = $field_id;
        $return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);
        echo $return; // it's array
    }
    
    public function actionDelete() {
        $id = $_POST['id'];
        if ($id > 0) {
            News::model()->deleteByPk($id);
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }
    
    public function actionDownloadEmails()
	{
		$file = fopen("csvs/email.csv","w");
		
		$model=new NewsLetterEmails();
		
		
		$arr_items=$model->findAll();
		foreach($arr_items as $i=>$row)
		{
			if($i==0)
			{
				$list[$i]=  'Email Id';
			}
			$list[$i+1]=  $row->email_id;
		}
		foreach ($list as $line)
		{
			fputcsv($file,explode(',',$line));
		}
		
		fclose($file);
		$filename = Yii::app()->getBaseUrl(true).'/csvs/email.csv';
		$path=Yii::app()->getBaseUrl(true).'/csvs';
		header('Content-Type: application/csv');
		header("Content-disposition: attachment; filename=\"email.csv\"");
		readfile($filename);
		Yii::app()->end();
		return;
	}
}
