<?php
class CategoryController extends Controller {
    public $title = "Category";
    public function accessRules() {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(
                    'Index', 'Create', 'GetList', 'Save', 'DeleteCategory',
                    'BlockCategory', 'UnBlockCategory', 'Upload' ,'uploadImage'
                 ),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }
    public function actionIndex() {
       // if (isset(Yii::app()->Category->havePermissionOn['user']) || isset(Yii::app()->user->havePermissionOn['admin_user_view']) || Yii::app()->user->authorised_user == 1) {
            $this->render('index');
        //     } else {
        //      throw new CHttpException(401, 'Unauthorized Access');
        // }
    }
    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
    public function actionGetList() {
        $model = new Category();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'main_category_id',
            2 => 'category',
            3 => 'banner',
            4 => 'id'
         );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1 ';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and (category LIKE '%" . $searchString . "%'  )";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $div = '';
            // if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["admin_user_edit"]) || isset(Yii::app()->user->havePermissionOn['admin_user_edit'])) {
                $div .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'category/create&id=' . $row['id'] . '\',\' Category\',\'sm\')"><i class="fas fa-edit"></i></button>';
                $div .= ' <a href ="#" class="btn btn-danger btn-xs" onclick="deletecategory(' . $row['id'] . ')"><i class="fa fa-trash-o"></i></a>';
              
                // }
           //  if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["admin_user_delete"]) || isset(Yii::app()->user->havePermissionOn['admin_user_delete'])) {
                // if ($row->isActive == 'Y') {
                //     $div .= ' <a href ="#" class="btn btn-success btn-xs" onclick="disablecategory(' . $row['id'] . ')"><i class="fa fa-toggle-on"></i></a>';
                // }
                // if ($row->isActive == 'N') {
                //     $div .= ' <a href ="#" class="btn btn-danger btn-xs" onclick="enablecategory(' . $row['id'] . ')"><i class="fa fa-ban"></i></a>';
                // }
            // }
            $rowData[] = array(
                $m,
                $row->maincategory->main_category,
                $row['category'],
                //'<img src="/images/banner/'.$row['banner'].'" height="15" width="50" />',
                !empty($row['banner']) ? '<img src="/images/banner/'.$row['banner'].'" height="15" width="50" />' : '',
                '<div class="btn-wrap text-center">' . $div . '</div>',
                array('id' => $row['id'], 'code' => $row['category'])
            );
            $m++;
        }
        $data['draw'] = $draw;
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionCreate() {
        $model = new Category();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create', array('model' => $model), false, false);
    }
    public function actionSave() {
        $model = new Category();
        $other = array();
        $valid = true;
        if (isset($_POST['Category'])) {
            if ((int) @$_POST['Category']['id'] > 0) {
                $id = (int) @$_POST['Category']['id'];
                $model = $model->findByPk($id);
                $model->scenario ="edit";
             } else {
                 $model->scenario = 'add';
                $audit_type = 'CREATED';
            }
            $model->attributes = $_POST['Category'];
            $cat_id= trim($_POST['Category']['main_category_id']);
            $cat_name= trim($_POST['Category']['category']);
              $modelCategory = new Category();
              if($model->scenario == 'add')
              {
                $condition ='main_category_id="' . $cat_id . '" AND category="'.$cat_name.'" AND isActive="Y"';
              }
              else
              {
                $condition ='main_category_id="' . $cat_id . '" AND category="'.$cat_name.'" AND isActive="Y" AND id!='.$model->id;
              }
              $modelCount = $modelCategory->count(array('condition' => $condition));
              if ($modelCount > 0) {
              $other[] = $cat_name.' Name Already Taken';
              $valid = false;
              }
              $valid = $valid && $model->validate();
            if ($valid) {
                $model->save();
                $jsonData['status'] = 'success';
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error1, $other));
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionDeleteCategory() {
        $id = $_POST['id'];
        if ($id > 0) {
            Category::model()->deleteByPk($id);
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }
    public function actionUnBlockCategory() {
        $id = $_POST['id'];
        if ($id > 0) {
            Category::model()->updateByPK($id, array('isActive' => "Y"));
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }
    public function actionUpload($folder = null,$filename=null){
        Yii::import("ext.EAjaxUpload.qqFileUploader");
        $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';
        // make the directory to store the pic:
        if (!is_dir($folder)) {
            mkdir($folder, 0777, TRUE);
        }
        //$allowedExtensions = array("csv");
        $allowedExtensions = array("jpg","jpeg","gif","exe","mov","pdf","doc","png","zip","bin","hid","tar","rar");
        $sizeLimit = 2 * 1024 * 1024;

        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        $result = $uploader->handleUpload($folder, FALSE, $filename);
        $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);
        //$result['field_id'] = $field_id;
        $return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);
        echo $return; // it's array
    }

    public function actionuploadImage($folder = null, $filename = null)
    {
        Yii::import("ext.EAjaxUpload.qqFileUploader");
        $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';
        // make the directory to store the pic:
        if (!is_dir($folder)) {
            mkdir($folder, 0777, TRUE);
        }
        //$allowedExtensions = array("csv");
        $allowedExtensions = array("jpg","jpeg","gif","exe","mov","pdf","doc","png","zip","bin","hid","tar","rar");
        $sizeLimit = 2 * 1024 * 1024;

        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        $result = $uploader->handleUpload($folder, FALSE, $filename);
        $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);
        //$result['field_id'] = $field_id;
        $return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);
        echo $return; // it's array
    }
     
}
