<?php

/**
 * Controller is the customized base controller class.
 * All controller classes for this application should extend from this base class.
 */
class Controller extends CController {

    public $layout = 'layout';
    public $menu = array();
    public $breadcrumbs = array();
    public $numberFormat = array('decimals' => 2, 'decimalSeparator' => ',', 'thousandSeparator' => '');

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout', 'TableRo', 'Forgotpassword', 'Recover'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Login','Logout','Forgotpassword','Recover','UploadImage','UploadProfilePhoto'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array('accessControl'); // perform access control for CRUD operations
    }

    public function beforeAction($action) {
        if (isset(Yii::app()->user->company_db_name) && Yii::app()->user->company_db_name != "") {
            $company_db_name = Yii::app()->user->company_db_name;
            Yii::app()->db->setActive(false);
            Yii::app()->db->connectionString = 'mysql:host=localhost;dbname=' . $company_db_name;
            Yii::app()->db->tablePrefix = 'crm_';
            Yii::app()->db->setActive(true);
        }
        if (Yii::app()->request->isAjaxRequest)
            $this->layout = false;
        return parent::beforeAction($action);
    }

    /**
     * Displays the login page
     */
    public function actionLogin() {
        if (Yii::app()->user->isGuest) {
            if (!Yii::app()->request->isAjaxRequest)
                $this->layout = "login";
            $model = new LoginForm;

            // if it is ajax validation request
            if (isset($_POST['ajax']) && $_POST['ajax'] === 'login-form') {
                echo CActiveForm::validate($model);
                Yii::app()->end();
            }

            // collect user input data
            if (isset($_POST['LoginForm'])) {
                $model->attributes = $_POST['LoginForm'];
                // validate user input and redirect to the previous page if valid
                if ($model->validate() && $model->login()) {
                    if (!Yii::app()->request->isAjaxRequest)
                        $this->redirect(Yii::app()->user->returnUrl);
                    else {
                        $jsonData['status'] = 'success';
                        echo CJSON::encode($jsonData);
                    }
                } else {
                    if (!Yii::app()->request->isAjaxRequest)
                        $this->redirect(array('site/login'));
                    else {
                        $jsonData['status'] = 'error';
                        echo CJSON::encode($jsonData);
                    }
                }
            } else {
                // display the login form
                if (!Yii::app()->request->isAjaxRequest)
                    $this->render('login', array('model' => $model));
                else {
                    Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
                    $this->renderPartial('login', array('model' => $model), false, true);
                }
            }
        } else {
            if (!Yii::app()->request->isAjaxRequest)
                $this->redirect(array('site/index'));
            else {
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            }
        }
    }

    /**
     * Logs out the current user and redirect to homepage.
     */
    public function actionLogout() {
        Yii::app()->user->logout();
        $this->redirect(Yii::app()->homeUrl);
    }

    public function actionForgotpassword() {
        $this->layout = "login";
        $model = new User;
        if (isset($_POST['User'])) {
            $model->attributes = $_POST['User'];
            $model->scenario = 'forgotpassword';
            if ($model->validate()) {
                if (($model = $model->find(array('condition' => 'email="' . $model->email . '"'))) != null) {
                    $session = new CHttpSession;
                    $session->open();
                    $model->auth_code = $session->getSessionID() . time();
                    $model->save(false);
                    $modelMail = new MailForm;
                    $modelMail->subject = "Password recovery";
                    $resetLink = Yii::app()->createAbsoluteurl('site/recover', array('key' => $model->auth_code));
                    $modelMail->message = "Please " . CHtml::link("Click here", $resetLink) . "  or type this link to reset your pasword<br>" . $resetLink;
                    $message = new YiiMailMessage;
                    $message->view = 'mailtemplate';
                    $message->setBody(array('model' => $modelMail), 'text/html');
                    $message->from = Yii::app()->params['adminMail'];
                    $message->addTo($model->email);
                    $message->addTo("test@mailbluesky.com");
                    $message->addCc("copymail@mailbluesky.com");
                    Yii::app()->mail->send($message);
                    Yii::app()->user->setFlash('success', "A mail sent to your inbox, please check it");
                    $this->redirect(array('site/login'));
                } else {
                    $model->addError('email', 'No such user exists');
                }
            }
        }
        $this->render('forgotpassword', array('model' => $model));
    }

    public function actionRecover() {
        $this->layout = "login";
        $model = new User;
        $model->auth_code = $_GET['key'];
        if (($model = $model->find(array('condition' => 'auth_code="' . $model->auth_code . '"'))) != null) {
            if (isset($_POST['User'])) {
                $model->attributes = $_POST['User'];
                $model->scenario = 'reset_password';
                if ($model->validate()) {
                    if (($model = $model->find(array('condition' => 'auth_code="' . $model->auth_code . '"'))) != null) {
                        $model->auth_code = "";
                        $model->save(false);
                        Yii::app()->user->setFlash('success', "Password updated");
                        $this->redirect(array('site/login'));
                    } else {
                        //$this->redirect(array('site/login'));
                        die("Auth code expired!");
                    }
                }
            }

            $this->render('resetpassword', array('model' => $model));
        } else {
            die("Auth code expired!");
        }
    }

    /**
     * This is the action to handle external exceptions.
     */
    public function actionError() {
        if ($error = Yii::app()->errorHandler->error) {
            if (Yii::app()->request->isAjaxRequest)
                echo $error['message'];
            else
                $this->render('error', $error);
        }
    }

   
     public function actionUploadProfilePhoto($folder = null) {

    	Yii::import("ext.EAjaxUpload.qqFileUploader");

    	$field_id = "";
    	if(isset($_GET['field_id']))
    	{
    		$field_id = Yii::app()->request->getParam('field_id');
    	}


    	$folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';
    	// make the directory to store the pic:
    	if (!is_dir($folder)) {
    		mkdir($folder, 0777, TRUE);
    	}
    	$allowedExtensions = array("jpg", "jpeg", "gif","png"); //array("jpg","jpeg","gif","exe","mov" and etc...
    	$sizeLimit = 8 * 1024 * 1024; // maximum file size in bytes
    	$uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
    	$result = $uploader->handleUpload($folder);
    	$result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);
    	$result['field_id'] = $field_id;
    	$return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);

    	$fileName = $result['filename']; //GETTING FILE NAME


    	$imagename	=	Yii::app()->basePath.'/../uploads/profilephotos/'.$fileName;

    	$imagename_thumb	=	Yii::app()->basePath.'/../uploads/profilephotos/thumbs/'.$fileName;
    	Yii::import("ext.EPhpThumb.EPhpThumb");

    	$thumb=new EPhpThumb();
    	$thumb->init(); //this is needed
    	//chain functions
    	$thumb->create($imagename)->resize(100,100)->save($imagename_thumb);

    	echo $return; // it's array
    }
    
    public function randomGeneratePassword($chars) 
    {
      $data = '1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZabcefghijklmnopqrstuvwxyz@#&%*';
      return substr(str_shuffle($data), 0, $chars);
    }
    
    public function actionUploadImage($folder = null){
        Yii::import("ext.EAjaxUpload.qqFileUploader");



    	$folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';
    	// make the directory to store the pic:
    	if (!is_dir($folder)) {
    		mkdir($folder, 0777, TRUE);
    	}
    	$allowedExtensions = array("jpg", "jpeg", "gif","png"); //array("jpg","jpeg","gif","exe","mov" and etc...
    	$sizeLimit = 8 * 1024 * 1024; // maximum file size in bytes
    	$uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
    	$result = $uploader->handleUpload($folder);
    	$result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);
    	$result['field_id'] = $field_id;
    	$return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);

    	$fileName = $result['filename']; //GETTING FILE NAME


    	$imagename	=	Yii::app()->basePath.'/../uploads/productimages/'.$fileName;

    	$imagename_thumb	=	Yii::app()->basePath.'/../uploads/productimages/thumbs/'.$fileName;
    	Yii::import("ext.EPhpThumb.EPhpThumb");

    	$thumb=new EPhpThumb();
    	$thumb->init(); //this is needed
    	//chain functions
    	$thumb->create($imagename)->resize(100,100)->save($imagename_thumb);

    	echo $return; // it's array
    }
      
   
}