<?php
$mainDB = MasCompany::MainDB;
$today = date("Y-m-d");
$condition = " AND 1=1 ";
if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_customer_view_all"])) {

} else {
    $user_id = Yii::app()->user->id;
    $condition .= " AND U.id  = " . $user_id;
}
$sql = "SELECT U.user_full_name, current_sp, COUNT(*) as qty FROM crm_mas_customer C JOIN {$mainDB}.crm_user U ON (U.id = C.current_sp) WHERE C.status = 'P' $condition AND  date(C.prospect_lock_date) >= '$today' GROUP BY C.current_sp, U.user_full_name ";

$rawData = Yii::app()->db->createCommand($sql)->queryAll();
$data_label = [];
$data_value = [];
foreach ($rawData as $value) {
    $data_label[] = $value['user_full_name'];
    $data_value[] = $value['qty'];
}
?>
<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            <i class="fas fa-chart-pie mr-1"></i>
            Salesman Prospect
        </h3>
    </div>
    <!-- /.card-header -->
    <div class="card-body">
        <div class="tab-content p-0">
            <!-- JS chart - Sales -->
            <div onclick="loadPopupModal('dashboard/salesman_prospect', 'Salesman-Prospect', 'xl')"   class="chart tab-pane active" id="salesman-prospect-chart"
                 style="position: relative; height: 300px;">
                <canvas id="salesman-prospect-chart-canvas" height="300" style="height: 300px;">

                </canvas>
            </div>

        </div>
    </div>
    <!-- /.card-body -->
</div>
<script type="text/javascript" >
// on ready function
    $(document).ready(function () {
        console.log("ready!");
        var data = {
            labels: <?= json_encode($data_label); ?>,
            datasets: [{
                    label: 'Prospect',
                    data: <?= json_encode($data_value); ?>,
                    backgroundColor: '#00a65a', // Bar color
                    borderColor: '#00a65a', // Border color
                    borderWidth: 1
                },
            ]
        };
        var pieChartCanvas = $('#salesman-prospect-chart-canvas').get(0).getContext('2d');
        var config = {
            type: 'bar',
            data: data,
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scaleBeginAtZero: true,
                plugins: {
                    legend: {
                        position: 'top',
                    },
                    title: {
                        display: true,
                        text: 'Leads'
                    }
                },
                scales: {
                    x: {
                    },
                    y: {
                        beginAtZero: true
                    }
                }
            },
        };
        pieChartsalesManCustomer = new Chart(pieChartCanvas, config);
    });

</script>