<?php
$no_of_session = 4;
$model = MasStatus::model()->find(["condition" => "status_code= 'P' "]);
$prospect_lock_days = $model->lock_days;
$prospect_section_date = (int) ($prospect_lock_days / $no_of_session);
$prospect_data = [];
$priority = ["Urgent Priority",
    "High Priority",
    "Medium Priority",
    "Low Priority"];
$date_list = [];
for ($index = 0; $index < $no_of_session; $index++) {
    $day_from = $index * $prospect_section_date;
    $start_date = ($index == 0) ? date("Y-m-d") : date("Y-m-d", strtotime("+ $day_from days"));
    $day_to = (($index + 1) * $prospect_section_date) - 1;
    $end_date = date("Y-m-d", strtotime("+ $day_to days"));
    $date_list[$index] = [
        'start_date' => $start_date,
        'end_date' => $end_date
    ];
    $sql = " select count(*) from  crm_mas_customer where status ='P' AND  date(prospect_lock_date) >= '$start_date'  AND date(prospect_lock_date) <='$end_date' ";
    //echo $sql;
    if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_customer_view_all"])) {

    } else {
        $user_id = Yii::app()->user->id;
        $sql .= " AND current_sp = " . $user_id;
    }
    $prospect_data[$index] = Yii::app()->db->createCommand($sql)->queryScalar();
}
?>
<table class="info-table">
    <tr>
        <th>Priority</th>
        <th>No</th>
    </tr>
    <?php
    foreach ($prospect_data as $key => $each) {
        ?>
        <tr onclick="loadPriority('P', '<?= $date_list[$key]['start_date'] ?>', '<?= $date_list[$key]['end_date'] ?>')">
            <td>
                <?php echo $priority[$key]; ?>
            </td>
            <td>
                <?php echo $prospect_data[$key]; ?>
            </td>
        </tr>
        <?php
    }
    ?>
</table>
<script>
    function loadPriority(type, start_date, end_date) {
        jQuery.ajax({
            dataType: 'html',
            type: 'POST',
            url: 'index.php?r=dashboard/prioritylevel1',
            cache: false,
            data: {type: type, start_date: start_date, end_date: end_date},
            success: function (data) {
                $("#priority-container").html(data);
            },
            complete: function () {
                $("#loader").hide();
            },
            beforeSend: function () {
                $("#loader").show();
            }
        });
    }
</script>
<div id="priority-container">

</div>
