<?php
$no_of_session = 4;
// $model = MasStatus::model()->find(["condition" => "status_code= 'P' "]);
// $prospect_lock_days = $model->lock_days;

// $model = MasStatus::model()->find(["condition" => "status_code= 'C' "]);
// $customer_lock_days = $model->lock_days;

$prospect_section_date = (int) ($prospect_lock_days / $no_of_session);
$customer_section_date = (int) ($customer_lock_days / $no_of_session);

$prospect_data = [];
$customer_data = [];
$pri_data = ["Urgent Priority", "High Priority", "Medium Priority", "Low Priority"];

for ($index = 0; $index < $no_of_session; $index++) {
    $day_from = $index * $prospect_section_date;
    $start_date = ($index == 0) ? date("Y-m-d") : date("Y-m-d", strtotime("+ $day_from days"));
    $day_to = (($index + 1) * $prospect_section_date) - 1;
    $end_date = date("Y-m-d", strtotime("+ $day_to days"));
    $sql = " select count(*) from  crm_mas_customer where status ='P' AND  date(prospect_lock_date) >= '$start_date'  AND date(prospect_lock_date) <='$end_date' ";
    if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_customer_view_all"])) {

    } else {
        $user_id = Yii::app()->user->id;
        $sql .= " AND current_sp = " . $user_id;
    }
    $prospect_data[$index] = Yii::app()->db->createCommand($sql)->queryScalar();
}
for ($index = 0; $index < $no_of_session; $index++) {
    $day_from = $index * $customer_section_date;
    $start_date = ($index == 0) ? date("Y-m-d") : date("Y-m-d", strtotime("+ $day_from days"));
    $day_to = (($index + 1) * $customer_section_date) - 1;
    $end_date = date("Y-m-d", strtotime("+ $day_to days"));

    $sql = " select count(*) from  crm_mas_customer where status ='C' AND  date(customer_lock_date) >= '$start_date'  AND date(customer_lock_date) <='$end_date' ";
    if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_customer_view_all"])) {

    } else {
        $user_id = Yii::app()->user->id;
        $sql .= " AND current_sp = " . $user_id;
    }
//echo $sql;
    $customer_data[$index] = Yii::app()->db->createCommand($sql)->queryScalar();
}
?>
<script>
    // on ready function
    $(document).ready(function () {
        console.log("ready!");
        var pieChartCanvas = $('#prospect-chart-canvas').get(0).getContext('2d')
        var pieData = {
            labels: [
                "Urgent Priority",
                "High Priority",
                "Medium Priority",
                "Low Priority"
            ],
            datasets: [{
                    data: <?php echo json_encode($prospect_data); ?>,
                    backgroundColor: ['#f56954', '#f39c12', '#a4f312', '#00a65a']
                }]
        }
        var pieOptions = {
            legend: {
                display: false
            },
            maintainAspectRatio: false,
            responsive: true
        }
        // Create pie or douhnut chart
        // You can switch between pie and douhnut using the method below.
        // eslint-disable-next-line no-unused-vars
        var pieChart = new Chart(pieChartCanvas, {// lgtm[js/unused-local-variable]
            type: 'doughnut',
            data: pieData,
            options: pieOptions
        })
    });
</script>
<script>
    // on ready function
    $(document).ready(function () {
        console.log("ready!");
        var pieChartCanvas = $('#customer-chart-canvas').get(0).getContext('2d')
        var pieData = {
            labels: [
                "Urgent Priority",
                "High Priority",
                "Medium Priority",
                "Low Priority"
            ],
            datasets: [{
                    data: <?php echo json_encode($customer_data); ?>,
                    backgroundColor: ['#f56954', '#f39c12', '#a4f312', '#00a65a']
                }]
        }
        var pieOptions = {
            legend: {
                display: false
            },
            maintainAspectRatio: false,
            responsive: true
        }
        // Create pie or douhnut chart
        // You can switch between pie and douhnut using the method below.
        // eslint-disable-next-line no-unused-vars
        var pieChart = new Chart(pieChartCanvas, {// lgtm[js/unused-local-variable]
            type: 'doughnut',
            data: pieData,
            options: pieOptions
        })
    });
</script>
<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            <i class="fas fa-chart-pie mr-1"></i>
            Priority
        </h3>
        <div class="card-tools">
            <ul class="nav nav-pills ml-auto">
                <li class="nav-item">
                    <a class="nav-link active" href="#prospect-chart" data-toggle="tab">Prospect</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="#customer-chart" data-toggle="tab">Customer</a>
                </li>
            </ul>
        </div>
    </div>
    <!-- /.card-header -->
    <div class="card-body">
        <div class="tab-content p-0">
            <!-- Morris chart - Sales -->
            <div class="chart tab-pane active" id="prospect-chart"
                 onclick="load_prospect_priority()"
                 style="position: relative; height: 300px;">
                <canvas id="prospect-chart-canvas" height="300" style="height: 300px;"></canvas>
            </div>
            <div class="chart tab-pane" id="customer-chart"
                 onclick="load_customer_priority()"
                 style="position: relative; height: 300px;">
                <canvas id="customer-chart-canvas" height="300" style="height: 300px;"></canvas>
            </div>
        </div>
    </div>
    <!-- /.card-body -->
</div>
<script>
    function load_prospect_priority() {
        var url = "dashboard/priorityprospect"
        loadPopupModal(url, 'Prospect', 'xl');

    }
    function load_customer_priority() {
        var url = "dashboard/priorityCustomer"
        loadPopupModal(url, 'Customer', 'xl');
    }
</script>