<?php
$no_of_session = 4;
$model = MasStatus::model()->find(["condition" => "status_code= 'C' "]);
$customer_lock_days = $model->lock_days;
$customer_section_date = (int) ($customer_lock_days / $no_of_session);
$customer_data = [];
$priority = ["Urgent Priority",
    "High Priority",
    "Medium Priority",
    "Low Priority"];
for ($index = 0; $index < $no_of_session; $index++) {
    $day_from = $index * $customer_section_date;
    $start_date = ($index == 0) ? date("Y-m-d") : date("Y-m-d", strtotime("+ $day_from days"));
    $day_to = (($index + 1) * $customer_section_date) - 1;
    $end_date = date("Y-m-d", strtotime("+ $day_to days"));
    $date_list[$index] = [
        'start_date' => $start_date,
        'end_date' => $end_date
    ];
    $sql = " select count(*) from  crm_mas_customer where status ='C' AND  date(customer_lock_date) >= '$start_date'  AND date(customer_lock_date) <='$end_date' ";

    if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_customer_view_all"])) {

    } else {
        $user_id = Yii::app()->user->id;
        $sql .= " AND current_sp = " . $user_id;
    }

    $customer_data[$index] = Yii::app()->db->createCommand($sql)->queryScalar();
}
?>
<table class="info-table">
    <tr>
        <th>Priority</th>
        <th>No of Customer</th>
    </tr>
    <?php
    foreach ($customer_data as $key => $each) {
        ?>
        <tr onclick="loadPriority('C', '<?= $date_list[$key]['start_date'] ?>', '<?= $date_list[$key]['end_date'] ?>')">
            <td>
                <?php echo $priority[$key]; ?>
            </td>
            <td>
                <?php echo $customer_data[$key]; ?>
            </td>
        </tr>
        <?php
    }
    ?>
</table>
<script>
    function loadPriority(type, start_date, end_date) {
        jQuery.ajax({
            dataType: 'html',
            type: 'POST',
            url: 'index.php?r=dashboard/prioritylevel1',
            cache: false,
            data: {type: type, start_date: start_date, end_date: end_date},
            success: function (data) {
                $("#priority-container").html(data);
            },
            complete: function () {
                $("#loader").hide();
            },
            beforeSend: function () {
                $("#loader").show();
            }
        });
    }
</script>
<div id="priority-container">

</div>
