<?php
$user_id = Yii::app()->user->id;
$today = date("Y-m-d");
$condition = "follow_up = 'Y' AND  t.created_by = '$user_id' AND date(deadline_date_time)= '$today'";
$models = Activity::model()->findAll(["condition" => $condition, "order" => "id desc"]);
?>
<table style="width: 99%" id="tbl-my-follow-up" class="table-bordered">
    <thead>
        <tr>
            <th>Customer</th>
            <th>Contact</th>
            <th>Mobile</th>
            <th>Type</th>
            <th>Completed</th>
            <th>Created At</th>
            <th></th>
        </tr>
    </thead>
    <tbody>
        <?php
        foreach ($models as $value) {
            ?>
            <tr>
                <td><?php echo $value->cust->name ?></td>
                <td><?php echo $value->contact_rel->contact_name ?></td>
                <td><?php echo $value->contact_rel->contact_mobile ?></td>
                <td><?php echo $value->follow_activity_type_rel->activity_type ?></td>
                <td><?php echo ($value->completed == "Y") ? "Yes" : "No" ?></td>
                <td><?php echo ($value->follow_up == "Y") ? date("d/m/Y", strtotime($value->created_date_time)) : "-" ?></td>
                <td>
                    <div class="btn-wrap text-center">
                        <button class="btn btn-primary btn-xs" onclick="loadPopupModal('activity/activity/create&amp;id=<?= $value->id ?>', 'Edit Activity', 'xl')">
                            <i class="fa fa-edit" title="Edit"></i>
                        </button>
                    </div>
                </td>
            </tr>
            <?php
        }
        ?>
    </tbody>

</table>
<script>
    $(document).ready(function () {
        $("#tbl-my-follow-up").DataTable({
            pageLength: 10,
            processing: true,
            height: '350px'
        });
    });

</script>

