<?php

/**
 * This is the model class for table "{{user}}".
 *
 * The followings are the available columns in table '{{user}}':
 * @property integer $id
 * @property string $username
 * @property string $password
 * @property string $user_image
 * @property string $first_name
 * @property string $last_name
 * @property string $user_code
 * @property string $designation
 * @property string $phone
 * @property string $email_id
 * @property string $isActive
 * @property integer $daily_calltarget
 * @property integer $sales_target
 * @property integer $department
 * @property string $user_color
 * @property integer $created_by
 * @property string $created_date
 * @property integer $updated_by
 * @property string $updated_date
 * @property string $token
 */
class User extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{user}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('username, password, first_name, last_name, phone, email_id, designation, user_group_id, created_by, created_date', 'required'),
			array('daily_calltarget, sales_target, department, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('username, phone, email_id', 'length', 'max'=>50),
			array('password, user_image, user_color, token', 'length', 'max'=>255),
			array('first_name, last_name', 'length', 'max'=>100),
			array('user_code', 'length', 'max'=>30),
			array('designation', 'length', 'max'=>200),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, username, password, user_image, first_name, last_name, user_code, designation, phone, email_id, isActive, daily_calltarget, sales_target, department, user_color, created_by, created_date, updated_by, updated_date, token', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		     "userGroup" => [self::BELONGS_TO, "MasUserGroup", "user_group_id"]
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'username' => 'Username',
			'password' => 'Password',
			'user_image' => 'user_image',
			'first_name' => 'First Name',
			'last_name' => 'Last Name',
			'user_code' => 'User Code',
			'designation' => 'Designation',
			'phone' => 'Phone',
			'email_id' => 'Email',
			'isActive' => 'Is Active',
			'daily_calltarget' => 'Daily Calltarget',
			'sales_target' => 'Sales Target',
			'department' => 'Department',
			'user_color' => 'User Color',
			'created_by' => 'Created By',
			'created_date' => 'Created Date',
			'updated_by' => 'Updated By',
			'updated_date' => 'Updated Date',
			'token' => 'Token',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('username',$this->username,true);
		$criteria->compare('password',$this->password,true);
		$criteria->compare('user_image',$this->user_image,true);
		$criteria->compare('first_name',$this->first_name,true);
		$criteria->compare('last_name',$this->last_name,true);
		$criteria->compare('user_code',$this->user_code,true);
		$criteria->compare('designation',$this->designation,true);
		$criteria->compare('phone',$this->phone,true);
		$criteria->compare('email_id',$this->email_id,true);
		$criteria->compare('isActive',$this->isActive,true);
		$criteria->compare('daily_calltarget',$this->daily_calltarget);
		$criteria->compare('sales_target',$this->sales_target);
		$criteria->compare('department',$this->department);
		$criteria->compare('user_color',$this->user_color,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date',$this->created_date,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date',$this->updated_date,true);
		$criteria->compare('token',$this->token,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return User the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	function beforeSave() {
        if (isset($_POST['User']['password']) && $_POST['User']['password'] != '') {
            //START Code modified on 08-04-2016 for secured password
            $salt = '$2a$10$1qAz2wSx3eDc4rFv5tGb5t';
            $this->password = crypt($_POST['User']['password'], $salt);
            //END Code modified on 08-04-2016 for secured password
            //$this->password = crypt($_POST['User']['password'], $_POST['User']['password']);
        }
        return true;
    }
    public static function getAll() {
        $condition = " isActive='Y' ";
        $model = self::model()->findAll(array('select' => array('id', 'first_name','last_name'), 'condition'=>$condition,'order' => 'first_name'));
        return CHtml::listData($model, 'id',  'FullName');
    }
    public function getFullName(){
    	return $this->first_name.' '.$this->last_name;
    }
    
    public static function getSalesPersons() {
        //$condition = 'isActive =  "Y" AND FIND_IN_SET ("3", user_type)';//
        //$condition = 'isActive =  "Y" AND (user_type="3" OR user_type="11")';
        $condition = 'isActive =  "Y" AND user_group_id IN(3,11,12)';
        $model = User::model()->findAll(array('select' => array('id', 'first_name', 'last_name'), 'condition' => $condition, 'order' => 't.first_name'));
        return CHtml::listData($model, 'id', 'fullname');
    }
}
