<?php

/**
 * This is the model class for table "{{research_sale_note}}".
 *
 * The followings are the available columns in table '{{research_sale_note}}':
 * @property integer $id
 * @property integer $magazine_id
 * @property integer $edition_id
 * @property integer $topic_id
 * @property integer $customer_id
 * @property integer $note_status
 * @property string $notes
 * @property integer $created_date
 * @property integer $created_by
 */
class ResearchSaleNote extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{research_sale_note}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('magazine_id, edition_id, topic_id, customer_id, note_status, created_by', 'required'),
            array('magazine_id, edition_id, topic_id, customer_id, note_status,  created_by, contact_id,new_note_status', 'numerical', 'integerOnly' => true),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, magazine_id, edition_id, topic_id, customer_id, note_status, notes, created_date, created_by, callback_date, status', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'user' => array(self::BELONGS_TO, 'User', 'created_by'),
            'customer' => array(self::BELONGS_TO, 'Customer', 'customer_id'),
            'magazine' => array(self::BELONGS_TO, 'MasterMagazine', 'magazine_id'),
            'edition' => array(self::BELONGS_TO, 'MasterEdition', 'edition_id'),
            'customercontact' => array(self::BELONGS_TO, 'Customercontact', 'contact_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'magazine_id' => 'Magazine',
            'edition_id' => 'Edition',
            'topic_id' => 'Topic',
            'customer_id' => 'Customer',
            'note_status' => 'Note Status',
            'notes' => 'Notes',
            'created_date' => 'Created Date',
            'created_by' => 'Created By',
            'contact_id' => 'Contact',
            'callback_date' => 'Callback Date',
            'status' => 'Status',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search($customer_id = 0, $topic_id = 0, $user_id = 0) {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $magazine_id = trim(Yii::app()->request->getParam('magazine_id'));
        $edition_id = trim(Yii::app()->request->getParam('edition_id'));
        if ($topic_id <= 0) {
            $note_status = trim(Yii::app()->request->getParam('note_status'));
        }
        $companycontact = trim(Yii::app()->request->getParam('companycontact'));
        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('magazine_id', $this->magazine_id);
        $criteria->compare('edition_id', $this->edition_id);
        $criteria->compare('topic_id', $this->topic_id);
        $criteria->compare('customer_id', $this->customer_id);
        $criteria->compare('note_status', $this->note_status);
        $criteria->compare('notes', $this->notes, true);
        $criteria->compare('created_date', $this->created_date);
        $criteria->compare('created_by', $this->created_by);
        $criteria->compare('contact_id', $this->contact_id);
        $criteria->compare('callback_date', $this->callback_date, true);
        //$criteria->compare('status', $this->status, true);
        if (!empty($magazine_id)) {
            $criteria->addCondition('magazine_id=' . $magazine_id);
        }
        if (!empty($edition_id)) {
            $criteria->addCondition('edition_id=' . $edition_id);
        }
        if ($note_status > 0) {
            $criteria->addCondition('note_status=' . $note_status);
        }
        if ($customer_id > 0) {
            $criteria->addCondition('customer_id=' . $customer_id);
        }
        if ($topic_id > 0) {
            $criteria->addCondition('topic_id=' . $topic_id);
        }
        if ($user_id > 0) {
            $criteria->addCondition('user_id=' . $user_id);
        }
        if (!empty($companycontact)) {
            $criteria->addCondition('contact_id=' . $companycontact);
        }
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.id DESC',
            ),
            //'pagination'=>true,   
            'pagination' => array('pageSize' => Yii::app()->params['defaultPageSize'])
        ));
    }

    public function searchCallsToday() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('magazine_id', $this->magazine_id);
        $criteria->compare('edition_id', $this->edition_id);
        $criteria->compare('topic_id', $this->topic_id);
        $criteria->compare('customer_id', $this->customer_id);
        $criteria->compare('note_status', $this->note_status);
        $criteria->compare('notes', $this->notes, true);
        $criteria->compare('created_date', $this->created_date);
        $criteria->compare('created_by', $this->created_by);
        $criteria->compare('contact_id', $this->contact_id);
        $criteria->compare('callback_date', $this->callback_date);
//        $status = 'Y';
//        // DATE(`timestamp`) = CURDATE()
//        //$criteria->addCondition('created_date like '."'".date('Y-m-d')."%' AND created_by='".Yii::app()->user->userid."' AND status='".$status."'", 'AND');
//        $criteria->addCondition("DATE(`created_date`) = CURDATE() AND created_by='" . Yii::app()->user->userid . "'", 'AND');
//        $dashboardDepartmentSelect = Yii::app()->request->getParam('dashboardDepartmentSelect');
//        if(!empty($dashboardDepartmentSelect)){
//            $criteria->with='user';
//            $criteria->addCondition('user.department='.$dashboardDepartmentSelect,'AND');
//        }
//        
//        
//        return new CActiveDataProvider($this, array(
//            'criteria' => $criteria,
//            'pagination' => false,
//            'sort' => array(
//                'defaultOrder' => 't.id DESC',
//            ),
//        ));
        
         $status = 'Y';
       // $criteria->addCondition("DATE(`created_date`) = CURDATE() AND created_by='" . Yii::app()->user->userid . "'", 'AND');
        $dashboardDepartmentSelect = Yii::app()->request->getParam('dashboardDepartmentSelect');
        if(!empty($dashboardDepartmentSelect)){
            $criteria->with='user';
            $criteria->addCondition('user.department='.$dashboardDepartmentSelect,'AND');
        }
        
        //$criteria->addCondition('callback_date like ' . "'" . date('Y-m-d') . "%' AND created_by='" . Yii::app()->user->userid . "' AND status='" . $status . "'", 'AND');
        
        if(Yii::app()->user->usertype==1 || Yii::app()->user->usertype==2)
        {
        	$criteria->addCondition('DATE(created_date)=' . "'" . date('Y-m-d') . "'", 'AND');
        }
        else 
        {
        	$criteria->addCondition('DATE(created_date)=' . "'" . date('Y-m-d') . "' AND created_by='" . Yii::app()->user->userid . "'", 'AND');
        }
         $call_Llist = ResearchSaleNote::model()->findAll($criteria);
        $call_details = array();
        $i = 0;
        foreach ($call_Llist as $value) {
            $call_details[$i]["id"] = $value->id;
            $call_details[$i]["edition_name"] = $value->edition->edition_name;
            $call_details[$i]["customer_name"] = $value->customer->customer_name;
            $call_details[$i]["created_date"] = $value->callback_date;
            $call_details[$i]["notes"] = $value->notes;
            $call_details[$i]["iscalled"] = $value->status;
            $call_details[$i]["dept"] = $value->user->dept->department;
            $call_details[$i]["ftype"] =1;
//            $customer_id=$value->customer_id;
//            $criteria1 = new CDbCriteria;
//            $criteria1->addCondition('created_date like ' . "'" . date('Y-m-d') . "%' AND customer_id=".$customer_id, 'AND');
//            $new_call = ResearchSaleNote::model()->findAll($criteria1);
//            $call_details[$i]["iscalled"] =count($new_call);
            $i++;
        }
        $criteria1 = new CDbCriteria;
        if(Yii::app()->user->usertype==1 ||  Yii::app()->user->usertype==2)
        {
        	$criteria1->addCondition('DATE(created_date)=' . "'" . date('Y-m-d') . "'", 'AND');
        }
        else 
        {
        	$criteria1->addCondition('DATE(created_date)=' . "'" . date('Y-m-d') . "' AND created_id='" . Yii::app()->user->userid . "'", 'AND');
        }
         if(!empty($dashboardDepartmentSelect)){
            $criteria1->with='user';
            $criteria1->addCondition('user.department='.$dashboardDepartmentSelect,'AND');
        }
        $call_detail = GeneralNote::model()->findAll($criteria1);
         foreach ($call_detail as $value) {
             $call_details[$i]["id"] = $value->id;
            $call_details[$i]["edition_name"] ='-';
            $call_details[$i]["customer_name"] = $value->company->customer_name;
            $call_details[$i]["created_date"] = $value->created_date;
            $call_details[$i]["notes"] = $value->notes;
            $call_details[$i]["iscalled"] = $value->status;
             $call_details[$i]["dept"] = $value->user->dept->department;
            $call_details[$i]["ftype"] =2;
            $i++;
         }
          return new CArrayDataProvider($call_details, array(
            'id' => 'id',
            'pagination' => array(
                'pageSize' => 10,
            ),
        ));
    }

public function notContated() {
        /* $SQL = "SELECT customer_name,DATE_FORMAT(last_contacted,'%d %b %y') AS `last_contacted`
FROM (

SELECT `crm_customers`.`customer_name` , MAX( `created_date` ) AS `last_contacted`
FROM `crm_research_sale_note`
JOIN `crm_customers` ON ( `crm_customers`.`id` = `crm_research_sale_note`.`customer_id` )
GROUP BY `crm_customers`.`customer_name`
) AS a
WHERE a.last_contacted < date_sub(date(NOW( )), INTERVAL 4 week)"; */
    	
    	$SQL = "SELECT customer_id,customer_name,DATE_FORMAT(last_contacted,'%d-%m-%y') AS `last_contacted` FROM (SELECT note.customer_id,note.`customer_name` , MAX( `last_contacted` ) AS `last_contacted` FROM view_customer_note_details AS note GROUP BY note.`customer_name`
    	) AS company WHERE company.last_contacted < date_sub(date(NOW( )), INTERVAL 4 week)";
    	
    	$SQL.= " UNION ";
    	
    	$SQL.= "SELECT company.`id` AS customer_id,company.`customer_name`,'Not Contacted Yet' AS last_contacted FROM `crm_customers` AS company LEFT JOIN `view_customer_note_details` AS note ON ( company.`id` = note.`customer_id` ) WHERE customer_id IS NULL";
    	
    	//echo $SQL;
    	
        $arr_invoice_details = Yii::app()->db->createCommand($SQL)->queryAll();
        
        //echo '<pre>';
       // print_r($arr_invoice_details);
        
        $count = count($arr_invoice_details);
        return new CSqlDataProvider($SQL, array(
            'totalItemCount' => $count,
            /* 'sort'=>array(
              'attributes'=>array(
              'id', 'username$SQL', 'email',
              ),
              ), */
            'pagination' => false
        ));
    }

//        public function notContated()
//	{
//		// @todo Please modify the following code to remove attributes that should not be searched.
//
//		$criteria=new CDbCriteria;
//
//		$criteria->compare('id',$this->id);
//		$criteria->compare('magazine_id',$this->magazine_id);
//		$criteria->compare('edition_id',$this->edition_id);
//		$criteria->compare('topic_id',$this->topic_id);
//		$criteria->compare('customer_id',$this->customer_id);
//		$criteria->compare('note_status',$this->note_status);
//		$criteria->compare('notes',$this->notes,true);
//		$criteria->compare('created_date',$this->created_date);
//		$criteria->compare('created_by',$this->created_by);
//		$criteria->compare('contact_id',$this->contact_id);
//                $criteria->compare('callback_date',$this->callback_date);
//		$status='Y';
//                // DATE(`timestamp`) = CURDATE()
//                //$criteria->addCondition('created_date like '."'".date('Y-m-d')."%' AND created_by='".Yii::app()->user->userid."' AND status='".$status."'", 'AND');
//		$criteria->addCondition( "DATE(`created_date`) =  DATE_SUB(curdate(), INTERVAL 4 WEEK) AND created_by='".Yii::app()->user->userid."'", 'AND');
//		return new CActiveDataProvider($this, array(
//			'criteria'=>$criteria,
//			'pagination'=>false,
//			'sort' => array(
//                            'defaultOrder' => 't.id DESC',
//			),
//		));
//	}

    public function searchFolloupsToday() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('magazine_id', $this->magazine_id);
        $criteria->compare('edition_id', $this->edition_id);
        $criteria->compare('topic_id', $this->topic_id);
        $criteria->compare('customer_id', $this->customer_id);
        $criteria->compare('note_status', $this->note_status);
        $criteria->compare('notes', $this->notes, true);
        $criteria->compare('created_date', $this->created_date);
        $criteria->compare('created_by', $this->created_by);
        $criteria->compare('contact_id', $this->contact_id);
        //$status = 'N';
        //$criteria->addCondition('callback_date like ' . "'" . date('Y-m-d') . "%' AND created_by='" . Yii::app()->user->userid . "' AND status='" . $status . "'", 'AND');
        if(Yii::app()->user->usertype==1 ||  Yii::app()->user->usertype==2){
        	$criteria->addCondition('DATE(callback_date)=' . "'" . date('Y-m-d') . "'", 'AND');
        	$criteria->addCondition('DATE(created_date)!=' . "'" . date('Y-m-d') . "'", 'AND');
        }else {
        	$criteria->addCondition('DATE(callback_date)=' . "'" . date('Y-m-d') . "' AND created_by='" . Yii::app()->user->userid . "'", 'AND');
        	$criteria->addCondition('DATE(created_date)!=' . "'" . date('Y-m-d') . "'", 'AND');
        }
        $criteria->addCondition('new_note_status<>1', 'AND');
        $call_Llist = ResearchSaleNote::model()->findAll($criteria);
        
        $call_details = array();
        
        $i = 0;
        
        foreach ($call_Llist as $value) {
            $call_details[$i]["id"] = $value->id;
            $call_details[$i]["edition_name"] = $value->edition->edition_name;
            $call_details[$i]["customer_name"] = $value->customer->customer_name;
            $call_details[$i]["created_date"] = $value->callback_date;
            $call_details[$i]["notes"] = $value->notes;
            $call_details[$i]["iscalled"] = $value->new_note_status;
            $call_details[$i]["ftype"] =1;
//            $customer_id=$value->customer_id;
//            $criteria1 = new CDbCriteria;
//            $criteria1->addCondition('created_date like ' . "'" . date('Y-m-d') . "%' AND customer_id=".$customer_id, 'AND');
//            $new_call = ResearchSaleNote::model()->findAll($criteria1);
//            $call_details[$i]["iscalled"] =count($new_call);
            $i++;
        }
        
        $criteria1 = new CDbCriteria;
        if(Yii::app()->user->usertype==1 ||  Yii::app()->user->usertype==2){
        	$criteria1->addCondition('status=' . "'N'", 'AND');
        	$criteria1->addCondition('DATE(callback_date)<' . "'" . date('Y-m-d') . "'", 'AND');
        	$criteria1->addCondition('DATE(created_date)!=' . "'" . date('Y-m-d') . "'", 'AND');
        }else {
        	$criteria1->addCondition('status=' . "'N'", 'AND');
        	$criteria1->addCondition('DATE(callback_date)<' . "'" . date('Y-m-d') . "' AND created_by='" . Yii::app()->user->userid . "'", 'AND');
        	$criteria1->addCondition('DATE(created_date)!=' . "'" . date('Y-m-d') . "'", 'AND');
        }
        $criteria1->addCondition('new_note_status<>1', 'AND');
        $call_note_completed = ResearchSaleNote::model()->findAll($criteria1);
        foreach ($call_note_completed as $value) {
        	$call_details[$i]["id"] = $value->id;
        	$call_details[$i]["edition_name"] = $value->edition->edition_name;
        	$call_details[$i]["customer_name"] = $value->customer->customer_name;
        	$call_details[$i]["created_date"] = $value->callback_date;
        	$call_details[$i]["notes"] = $value->notes;
        	$call_details[$i]["iscalled"] = $value->new_note_status;
        	$call_details[$i]["ftype"] =1;
        	$i++;
        }
        
        
        $criteria2 = new CDbCriteria;
        //$criteria2->addCondition('callback_date like ' . "'" . date('Y-m-d') . "%' AND created_id='" . Yii::app()->user->userid . "' AND status='" . $status . "'", 'AND');
        if(Yii::app()->user->usertype==1 ||  Yii::app()->user->usertype==2)
        {
        	$criteria2->addCondition('DATE(callback_date)=' . "'" . date('Y-m-d') . "%'", 'AND');
        	$criteria2->addCondition('DATE(created_date)!=' . "'" . date('Y-m-d') . "'", 'AND');
        }
        else 
        {
        	$criteria2->addCondition('DATE(callback_date)=' . "'" . date('Y-m-d') . "%' AND created_id='" . Yii::app()->user->userid . "'", 'AND');
        	$criteria2->addCondition('DATE(created_date)!=' . "'" . date('Y-m-d') . "'", 'AND');
        }
         $criteria2->addCondition('new_note_status<>1', 'AND');
        $call_detail = GeneralNote::model()->findAll($criteria2);
         foreach ($call_detail as $value) {
            $call_details[$i]["id"] = $value->id;
            $call_details[$i]["edition_name"] ='-';
            $call_details[$i]["customer_name"] = $value->company->customer_name;
            $call_details[$i]["created_date"] = $value->callback_date;
            $call_details[$i]["notes"] = $value->notes;
            $call_details[$i]["iscalled"] = $value->new_note_status;
            $call_details[$i]["ftype"] =2;
            $i++;
         }
         $criteria3 = new CDbCriteria;
         //$criteria2->addCondition('callback_date like ' . "'" . date('Y-m-d') . "%' AND created_id='" . Yii::app()->user->userid . "' AND status='" . $status . "'", 'AND');
         if(Yii::app()->user->usertype==1 ||  Yii::app()->user->usertype==2)
         {
         	$criteria3->addCondition('status=' . "'N'", 'AND');
         	$criteria3->addCondition('DATE(callback_date)<' . "'" . date('Y-m-d') . "%'", 'AND');
         	$criteria3->addCondition('DATE(created_date)!=' . "'" . date('Y-m-d') . "'", 'AND');
         }
         else
         {
         	$criteria3->addCondition('status=' . "'N'", 'AND');
         	$criteria3->addCondition('DATE(callback_date)<' . "'" . date('Y-m-d') . "%' AND created_id='" . Yii::app()->user->userid . "'", 'AND');
         	$criteria3->addCondition('DATE(created_date)!=' . "'" . date('Y-m-d') . "'", 'AND');
         }
         $criteria3->addCondition('new_note_status<>1', 'AND');
         $call_detail = GeneralNote::model()->findAll($criteria3);
         foreach ($call_detail as $value) {
         	$call_details[$i]["id"] = $value->id;
         	$call_details[$i]["edition_name"] ='-';
         	$call_details[$i]["customer_name"] = $value->company->customer_name;
         	$call_details[$i]["created_date"] = $value->callback_date;
         	$call_details[$i]["notes"] = $value->notes;
         	$call_details[$i]["iscalled"] = $value->new_note_status;
         	$call_details[$i]["ftype"] =2;
         	$i++;
         }
          return new CArrayDataProvider($call_details, array(
            'id' => 'id',
            'pagination' => array(
                'pageSize' => 10,
            ),
        ));
//        return new CActiveDataProvider($this, array(
//            'criteria' => $criteria,
//            'pagination' => false,
//            'sort' => array(
//                'defaultOrder' => 't.id DESC',
//            ),
//        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return ResearchSaleNote the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public static function getNoteTitle($id) {
        switch ($id) {
            case 1:
                $title = "Picks";
                break;
            case 2:
                $title = "Projects";
                break;
            case 3:
                $title = "Allocate";
                break;
            case 4:
                $title = "Leads";
                break;
            case 5:
                $title = "Quotes";
                break;
            case 6:
                $title = "Orders";
                break;
            case 7:
                $title = "Deliveries";
                break;
            case 8:
                $title = "Production";
                break;
            case 9:
                $title = "Invoice";
                break;
            default:
                $title = "";
        }
        return $title;
    }

    public static function getmyNotesMagazine($customer_id) {
        $list = array();
        $myid = Yii::app()->user->userid;
        $condition = 'created_by=' . $myid;
        if ($customer_id > 0) {
            $condition.= ' AND customer_id=' . $customer_id;
        }
        $model = self::model()->findAll(array('select' => 't.magazine_id', 'condition' => $condition, 'distinct' => 'true'));
        foreach ($model as $value) {
            $list[$value->magazine_id] = $value->magazine->magazine_name;
        }
        return $list;
    }

    public static function getmyNotesEdition($magazine_id, $customer_id) {
        $list = array();
        $myid = Yii::app()->user->userid;
        $condition = 'created_by=' . $myid;
        if ($magazine_id > 0) {
            $condition.= ' AND magazine_id=' . $magazine_id;
        }
        if ($customer_id > 0) {
            $condition.= ' AND customer_id=' . $customer_id;
        }
        $model = self::model()->findAll(array('select' => 't.edition_id', 'condition' => $condition, 'distinct' => 'true'));
        foreach ($model as $value) {
            $list[$value->edition_id] = $value->edition->edition_name;
        }
        return $list;
    }

    public static function getmyNoteStatus($edition_id, $customer_id) {
        $list = array();
        $myid = Yii::app()->user->userid;
        $condition = 'created_by=' . $myid;
        if ($edition_id > 0) {
            $condition.= ' AND edition_id=' . $edition_id;
        }
        if ($customer_id > 0) {
            $condition.= ' AND customer_id=' . $customer_id;
        }
        $model = self::model()->findAll(array('select' => 't.note_status', 'condition' => $condition, 'distinct' => 'true'));
        foreach ($model as $value) {
            $list[$value->note_status] = self::getNoteTitle($value->note_status);
        }
        return $list;
    }

}
