<?php

/**
 * This is the model class for table "{{research_plan_picks_feature}}".
 *
 * The followings are the available columns in table '{{research_plan_picks_feature}}':
 * @property integer $id
 * @property integer $magazine_id
 * @property string $feature_name
 * @property string $feature_description
 * @property string $researchmanager
 * @property string $feature_type
 * @property integer $status
 * @property string $is_active
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class ResearchPlanPicksFeature extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public $forwarded_edition;

    public function tableName() {
//        return '{{research_features}}';
        return '{{research_plan_picks_feature}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('magazine_id, edition_year, edition_id, feature_name, feature_description, feature_type_id', 'required'),
            array('magazine_id,edition_id, created_by, updated_by,feature_type_id, researchmanager', 'numerical', 'integerOnly' => true),
            array('feature_name, feature_description', 'length', 'max' => 255),
            array('is_active', 'length', 'max' => 1),
            array('default_allocate_sales_person_id', 'length', 'max' => 10),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, magazine_id, feature_name, feature_description, feature_type, is_active, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'planpicks' => array(self::BELONGS_TO, 'ResearchPlanPicks', 'magazine_id'),
            'featuretype' => array(self::BELONGS_TO, 'FeatureType', 'feature_type_id'),
            'manager' => array(self::BELONGS_TO, 'User', 'researchmanager'),
            'salesperson' => array(self::BELONGS_TO, 'User', 'default_allocate_sales_person_id'),
            'magazine' => array(self::BELONGS_TO, 'MasterMagazine', 'magazine_id'),
            'edition' => array(self::BELONGS_TO, 'MasterEdition', 'edition_id')
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'magazine_id' => 'Magazine',
            'edition_id' => 'Edition',
            'feature_name' => 'Feature Name',
            'feature_description' => 'Feature Description',
            'feature_type' => 'Feature Type',
            'is_active' => 'Is Active',
            'created_by' => 'Created By',
            'created_date_time' => 'Created Date Time',
            'updated_by' => 'Updated By',
            'updated_date_time' => 'Updated Date Time',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('magazine_id', $this->magazine_id);
        $criteria->compare('feature_name', $this->feature_name, true);
        $criteria->compare('feature_description', $this->feature_description, true);
        $criteria->compare('feature_type', $this->feature_type, true);
        $criteria->compare('is_active', $this->is_active, true);
        $criteria->compare('created_by', $this->created_by);
        $criteria->compare('created_date_time', $this->created_date_time, true);
        $criteria->compare('updated_by', $this->updated_by);
        $criteria->compare('updated_date_time', $this->updated_date_time, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return ResearchPlanPicksFeature the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public static function getFeature() {
        $condition = "is_active='Y'";
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 'feature_name ASC'));
        return CHtml::listData($model, 'id', 'feature_name');
    }

    public static function getFeaturewithDistinct() {
        $condition = "is_active='Y'";
        $model = self::model()->findAll(array('select' => array('t.id', 't.feature_name'), 'condition' => $condition,
            'order' => 'feature_name ASC',
            'distinct' => true));
        return CHtml::listData($model, 'id', 'feature_name');
    }

    public static function getFeatureList() {
        $condition = "is_active='Y'";
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 'feature_name ASC'));
        return CHtml::listData($model, 'id', 'feature_name');
    }

    public static function getFeatureByMagazineAndEdition($magazine_id = 0, $edition_id = 0) {
        //$condition = 'magazine_id="'.$magazine_id. '" AND edition_id="'.$edition_id. '"';
        //$model = ResearchPlanPicksFeature ::model()->with('planpicks')->findAll(array('condition' => $condition,'order'=>'feature_name'));
        $condition = 'edition_id="' . $edition_id . '"';
        $model = ResearchPlanPicksFeature ::model()->findAll(array('condition' => $condition, 'order' => 'feature_name'));
        return CHtml::listData($model, 'id', 'feature_name');
    }

    public static function getFeatureByPlanPicksId($magazine_id = 0) {
        $condition = 'magazine_id="' . $magazine_id . '"';
        $model = ResearchPlanPicksFeature ::model()->with('planpicks')->findAll(array('condition' => $condition, 'order' => 'feature_name'));
        return CHtml::listData($model, 'id', 'feature_name');
    }

    public static function getFeatures($magazine_id = 0) {
        $condition = "is_active='Y'";
        if ($magazine_id != '') {
            $condition .= " AND magazine_id= " . $magazine_id;
        }
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 'feature_name ASC'));
        return CHtml::listData($model, 'id', 'feature_name');
    }

    public function getFeatureName() {
        return ($this->feature_name . ' - ' . $this->manager->first_name . " " . $this->manager->last_name);
    }

    public static function getFeatureByMagazineAndEditionWithSalesPerson($magazine_id = 0, $edition_id = 0) {
        $condition = 'edition_id="' . $edition_id . '"';
        $model = ResearchPlanPicksFeature ::model()->findAll(array('condition' => $condition, 'order' => 'feature_name'));
        return CHtml::listData($model, 'id', 'FeatureName');
    }

    public static function getFeatureByMagazineAndYear($magazine_id = 0, $year = 0) {
        $condition = 't.magazine_id="' . $magazine_id . '" AND edition.year="' . $year . '"';
        $model = ResearchPlanPicksFeature ::model()->with('edition')->findAll(array('condition' => $condition, 'order' => 'feature_name'));
        return CHtml::listData($model, 'id', 'feature_name');
    }

    public static function getFeatureByMagazineAndyearWithSalesPerson($magazine_id = 0, $year = 0) {
        $condition = 't.magazine_id="' . $magazine_id . '" AND edition.year="' . $year . '"';
        $model = ResearchPlanPicksFeature ::model()->with('edition')->findAll(array('condition' => $condition, 'order' => 'feature_name'));
        return CHtml::listData($model, 'id', 'FeatureName');
    }

}
