<?php

/**
 * This is the model class for table "{{research_plan_picks}}".
 *
 * The followings are the available columns in table '{{research_plan_picks}}':
 * @property integer $id
 * @property integer $magazine_id
 * @property string $magazine_name
 * @property integer $edition_id
 * @property string $edition_name
 * @property integer $research_manager_id
 * @property string $research_manager_name
 * @property string $is_active
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class ResearchPlanPicks extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
        public $industry_id;
	public $category_id;	public $company_id;
    
	public function tableName()
	{
		return '{{research_plan_picks}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('magazine_id,edition_id', 'required'),
			array('magazine_id, edition_id, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('magazine_name, edition_name, research_manager_name', 'length', 'max'=>255),
			array('is_active', 'length', 'max'=>1),
                       array('edition_id', 'unique','message'=>'Plan already exist for selected edition'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, magazine_id, magazine_name, edition_id, edition_name, research_manager_id, research_manager_name, is_active, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
				'magazine' => array(self::BELONGS_TO, 'MasterMagazine', 'magazine_id'),
				'edition' => array(self::BELONGS_TO, 'MasterEdition', 'edition_id'),
				'user' => array(self::BELONGS_TO, 'User', 'research_manager_id'),
				'features'=>array(self::BELONGS_TO, 'ResearchPlanPicksFeature', 'plan_picks_id'),
                                'industry'=>array(self::BELONGS_TO, 'MasterIndustry', 'industry_id'),
                                'category'=>array(self::BELONGS_TO, 'MasterCategory', 'category_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'magazine_id' => 'Magazine',
			'magazine_name' => 'Magazine Name',
			'edition_id' => 'Edition',
			'edition_name' => 'Edition Name',
			'research_manager_id' => 'Research Manager',
			'research_manager_name' => 'user name from user table',
			'is_active' => 'Is Active',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('magazine_id',$this->magazine_id);
		$criteria->compare('magazine_name',$this->magazine_name,true);
		$criteria->compare('edition_id',$this->edition_id);
		$criteria->compare('edition_name',$this->edition_name,true);
		$criteria->compare('research_manager_id',$this->research_manager_id);
		$criteria->compare('research_manager_name',$this->research_manager_name,true);
		$criteria->compare('is_active',$this->is_active,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ResearchPlanPicks the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
      
        
        public static function getResearchManagerByMagazineAndEdition($magazine_id=0, $edition_id=0) {
        	$condition = 'magazine_id="'.$magazine_id. '" AND edition_id="'.$edition_id. '"';
        	$model = ResearchPlanPicks ::model()->with('user')->findAll(array('condition' => $condition,'order'=>'research_manager_name'));
        	return CHtml::listData($model, 'research_manager_id',function($user) {
                    return CHtml::encode($user->user->fullname);
                
                });
        }
}
