<?php

/**
 * This is the model class for table "crm_research_allocate_company".
 *
 * The followings are the available columns in table 'crm_research_allocate_company':
 * @property integer $id
 * @property integer $magazine_id
 * @property integer $feature_id
 * @property integer $company_id
 * @property integer $status
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class ResearchAdvertisingCompany extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
    public $company_name;
    public $adv_industry_id;
    public $adv_category_id;
    
	public function tableName()
	{
		return '{{research_advertising_company}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('company_id, status, created_by, created_date_time,sales_person', 'required'),
			array('magazine_id, edition_id,feature_id, company_id, sales_person, created_by, updated_by,contact_person', 'numerical', 'integerOnly'=>true),
			array('magazine_id', 'length', 'max'=>11),
                        // The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, magazine_id, feature_id, company_id,status, sales_person,artwork_collected_date,signed_date,created_by,contact_person, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{ 
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(								
                    'company'=>array(self::BELONGS_TO,'Company','company_id'),
                    'features'=>array(self::BELONGS_TO,'ResearchPlanPicksFeature','feature_id'),
                    'magazine' => array(self::BELONGS_TO, 'MasterMagazine','magazine_id'), 
                    'edition' => array(self::BELONGS_TO, 'MasterEdition','edition_id'), 
                    'salesperson' => array(self::BELONGS_TO, 'User', 'sales_person'),
                    'contactperson' => array(self::BELONGS_TO, 'CompanyContact', 'contact_person'),
                     'salesstatus' => array(self::BELONGS_TO, 'MasterSaleStatus', 'status'),
                    'company_contacts' => array(self::BELONGS_TO, 'CompanyContact', 'contact_person'),
                    'saleorder' => array(self::HAS_MANY, 'SalesDetails', 'id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'magazine_id' => 'Magazine',
			'edition_id' =>'Edition',
			'feature_id' => 'Feature',
			'company_id' => 'Company',
			'sales_person' => ' Sales Person',
            'status' => 'Status',
            'contact_person'=>'Contact Person',
            'artwork_collected_date' => 'Artwork Collected Date',
            'signed_date' => 'Signed Date',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('magazine_id',$this->magazine_id);
		$criteria->compare('feature_id',$this->feature_id);
		$criteria->compare('company_id',$this->company_id);
		$criteria->compare('sales_person',$this->sales_person);
                $criteria->compare('status',$this->status);
                $criteria->compare('artwork_collected_date',$this->artwork_collected_date,true);
                $criteria->compare('signed_date',$this->signed_date,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ResearchPicksCompany the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        //status in crm_research_allocate_company
        public static function getResearchStatus($id) {
            switch ($id) {
                case 1:
                    $title = "Cold";
                    break;
                case 2:
                    $title = "Warm";
                    break;
                case 3:
                    $title = "Hot";
                    break;
                case 4:
                    $title = "Sale";
                    break;
                case 5:
                    $title = "Booking form not signed";
                    break;
                case 6:
                    $title = "Booking form signed";
                    break;
                case 7:
                    $title = "Artwork Received";
                    break;
                case 8:
                    $title = "Invoice to be sent";
                    break;
                case 9:
                    $title = "Cancelled";
                    break;
                case 10:
                    $title = "Invoice Sent";
                    break;
                case 11:
                    $title = "Early Settlement";
                    break;
                default:
                    $title = "";
            }
            return $title;
        }
        
        public function GetFeatureSalesPersons($features_id)
        {
        	$SQL="SELECT CONCAT(first_name,' ',last_name) AS sales_person_name FROM `crm_research_allocate_company` INNER JOIN crm_user ON user_id=sales_person WHERE `feature_id`=".$features_id." GROUP BY `sales_person`";
        	$arr_sales_person = Yii::app()->db->createCommand($SQL)->queryAll();
        	$sales_person ="";
        	if(count($arr_sales_person) > 0)
        	{
	        	foreach ($arr_sales_person as $row)
	        	{
	        		if($sales_person=="")
	        			$sales_person=$row['sales_person_name'];
	        		else 
	        			$sales_person.=", ".$row['sales_person_name'];
	        	}
        	}
        	return $sales_person;
        }
        public static function getCompanyByFeatureId($feature_id=0) {
        	$condition = 'feature_id="'.$feature_id. '"';
        	$model = ResearchAllocateCompany::model()->with('company')->findAll(array('select'=>'t.company_id as id,company_name as company_id','condition' => $condition,'order'=>'company_name'));
        	return CHtml::listData($model, 'id', 'company_id');
        }
}
