<?php

/**
 * This is the model class for table "{{master_magazine}}".
 *
 * The followings are the available columns in table '{{master_magazine}}':
 * @property integer $id
 * @property string $magazine_name
 * @property string $magazine_code
 * @property string $icon
 * @property integer $auto_invoice_no
 * @property string $isActive
 * @property string $app_icon
 * @property integer $created_by
 * @property string $created_date
 * @property integer $updated_by
 * @property string $updated_date
 */
class MasterMagazine extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{master_magazine}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('magazine_name, magazine_code, created_by, created_date', 'required'),
			array('auto_invoice_no, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('magazine_name, magazine_code, icon, app_icon', 'length', 'max'=>255),
			array('isActive', 'length', 'max'=>1),
			array('magazine_name', 'validateName'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, magazine_name, magazine_code, icon, auto_invoice_no, isActive, app_icon, created_by, created_date, updated_by, updated_date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'magazine_name' => 'Magazine Name',
			'magazine_code' => 'Magazine Code',
			'icon' => 'Icon',
			'auto_invoice_no' => 'Auto Invoice No',
			'isActive' => 'Is Active',
			'app_icon' => 'App Icon',
			'created_by' => 'Created By',
			'created_date' => 'Created Date',
			'updated_by' => 'Updated By',
			'updated_date' => 'Updated Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('magazine_name',$this->magazine_name,true);
		$criteria->compare('magazine_code',$this->magazine_code,true);
		$criteria->compare('icon',$this->icon,true);
		$criteria->compare('auto_invoice_no',$this->auto_invoice_no);
		$criteria->compare('isActive',$this->isActive,true);
		$criteria->compare('app_icon',$this->app_icon,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date',$this->created_date,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date',$this->updated_date,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MasterMagazine the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
		public function validateName($attribute, $params)
	{
    
		$condition = "isActive='Y' ";
		if($this->id>0){
			$condition .=" AND id!='".$this->id."' ";
		}
	    $name = $this->$attribute;
	    $condition .= " AND isActive='Y'  AND magazine_name='" . $name . "'";
	 	$exst_model = self::model()->find(array('condition' => $condition));
		    if (!empty($exst_model)) {
		        $this->addError($attribute, 'Magazine Name must be unique.');
		    }
		
	}
	public static function getAll() {
        $condition = " isActive='Y'";
        $model = self::model()->findAll(array('select' => array('id', 'magazine_name'), 'condition'=>$condition,'order' => 'magazine_name'));
        return CHtml::listData($model, 'id', 'magazine_name');
    }
    public static function getMagazine($magazine_id) {
        $condition = 'id ="'.$magazine_id.'"';
        $model = self::model()->findAll(array('condition' => $condition));
        return CHtml::listData($model, 'id', 'magazine_name');
	}
     public function getImageMagazine() {
        return '<img src="images/logo.png">123'." ".$this->magazine_name;
    }
}
