<?php

/**
 * This is the model class for table "{{master_location}}".
 *
 * The followings are the available columns in table '{{master_location}}':
 * @property integer $id
 * @property string $location
 * @property string $state_id
 * @property string $isActive
 * @property integer $created_by
 * @property string $created_date
 * @property integer $updated_by
 * @property string $updated_date
 */
class MasterLocation extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{master_location}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('location, state_id, created_by, created_date', 'required'),
			array('created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('location, state_id', 'length', 'max'=>255),
			array('isActive', 'length', 'max'=>1),
			array('location', 'validateName'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, location, state_id, isActive, created_by, created_date, updated_by, updated_date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		     'StateName' => array(self::BELONGS_TO,'MasterState', 'state_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'location' => 'Location',
			'state_id' => 'State',
			'isActive' => 'Is Active',
			'created_by' => 'Created By',
			'created_date' => 'Created Date',
			'updated_by' => 'Updated By',
			'updated_date' => 'Updated Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('location',$this->location,true);
		$criteria->compare('state_id',$this->state_id,true);
		$criteria->compare('isActive',$this->isActive,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date',$this->created_date,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date',$this->updated_date,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MasterLocation the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
		public function validateName($attribute, $params)
	{
    
		$condition = "isActive='Y' ";
		if($this->id>0){
			$condition .=" AND id!='".$this->id."' ";
		}
	    $name = $this->$attribute;
	    $condition .= " AND isActive='Y'  AND location='" . $name . "'";
	 	$exst_model = self::model()->find(array('condition' => $condition));
		    if (!empty($exst_model)) {
		        $this->addError($attribute, 'Name must be unique for location.');
		    }
		
	}
}
