<?php

/**
 * This is the model class for table "{{master_edition}}".
 *
 * The followings are the available columns in table '{{master_edition}}':
 * @property integer $id
 * @property string $edition_name
 * @property integer $magazine_id
 * @property string $edition_code
 * @property string $edition_from
 * @property string $edition_to
 * @property integer $edition_month
 * @property integer $year
 * @property integer $auto_invoice_no
 * @property string $isActive
 * @property string $target
 * @property string $deadline
 * @property string $artwork_deadline
 * @property string $invoice_date
 * @property integer $created_by
 * @property string $created_date
 * @property integer $updated_by
 * @property string $updated_date
 */
class MasterEdition extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{master_edition}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('edition_name, magazine_id,target,created_by, created_date', 'required'),
			array('magazine_id, edition_month, year, auto_invoice_no, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('edition_name, target', 'length', 'max'=>255),
			array('edition_code', 'length', 'max'=>100),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, edition_name, magazine_id, edition_code, edition_from, edition_to, edition_month, year, auto_invoice_no, isActive, target, deadline, artwork_deadline, invoice_date, created_by, created_date, updated_by, updated_date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		    'EditionName' => array(self::BELONGS_TO,'MasterMagazine', 'magazine_id'),
		    'magazine' => array(self::BELONGS_TO,'MasterMagazine', 'magazine_id'),
		     
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'edition_name' => 'Edition Name',
			'magazine_id' => 'Magazine',
			'edition_code' => 'Edition Code',
			'edition_from' => 'Edition From',
			'edition_to' => 'Edition To',
			'edition_month' => 'Edition Month',
			'year' => 'Year',
			'auto_invoice_no' => 'Auto Invoice No',
			'isActive' => 'Is Active',
			'target' => 'Target',
			'deadline' => 'Deadline',
			'artwork_deadline' => 'Artwork Deadline',
			'invoice_date' => 'Invoice Date',
			'created_by' => 'Created By',
			'created_date' => 'Created Date',
			'updated_by' => 'Updated By',
			'updated_date' => 'Updated Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('edition_name',$this->edition_name,true);
		$criteria->compare('magazine_id',$this->magazine_id);
		$criteria->compare('edition_code',$this->edition_code,true);
		$criteria->compare('edition_from',$this->edition_from,true);
		$criteria->compare('edition_to',$this->edition_to,true);
		$criteria->compare('edition_month',$this->edition_month);
		$criteria->compare('year',$this->year);
		$criteria->compare('auto_invoice_no',$this->auto_invoice_no);
		$criteria->compare('isActive',$this->isActive,true);
		$criteria->compare('target',$this->target,true);
		$criteria->compare('deadline',$this->deadline,true);
		$criteria->compare('artwork_deadline',$this->artwork_deadline,true);
		$criteria->compare('invoice_date',$this->invoice_date,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date',$this->created_date,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date',$this->updated_date,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MasterEdition the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	public static function getAll() {
        $condition = " isActive='A'";
        $model = self::model()->findAll(array('select' => array('id', 'edition_name'), 'condition'=>$condition,'order' => 'edition_name'));
        return CHtml::listData($model, 'id', 'edition_name');
    }
}
