<?php

/**
 * This is the model class for table "{{master_country}}".
 *
 * The followings are the available columns in table '{{master_country}}':
 * @property integer $id
 * @property string $country_name
 * @property string $country_code
 * @property integer $created_by
 * @property string $created_date
 * @property integer $updated_by
 * @property string $updated_date
 * @property string $isActive
 */
class MasterCountry extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{master_country}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('country_name, country_code, created_by, created_date', 'required'),
			array('created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('country_name, country_code', 'length', 'max'=>255),
			array('isActive', 'length', 'max'=>1),
		    array('country_name', 'validateName'),
			array('country_code', 'validateCountryCode'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, country_name, country_code, created_by, created_date, updated_by, updated_date, isActive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'country_name' => 'Country Name',
			'country_code' => 'Country Code',
			'created_by' => 'Created By',
			'created_date' => 'Created Date',
			'updated_by' => 'Updated By',
			'updated_date' => 'Updated Date',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('country_name',$this->country_name,true);
		$criteria->compare('country_code',$this->country_code,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date',$this->created_date,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date',$this->updated_date,true);
		$criteria->compare('isActive',$this->isActive,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MasterCountry the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	public function validateCountryCode($attribute, $params)
	{
    
		$condition = "isActive='Y' ";
		if($this->id>0){
			$condition .=" AND id!='".$this->id."' ";
		}
	    $code = $this->$attribute;
	    $condition .= " AND isActive='Y'  AND country_code='" . $code . "'";
	 	$exst_model = self::model()->find(array('condition' => $condition));
		    if (!empty($exst_model)) {
		        $this->addError($attribute, 'Country Code must be unique for country.');
		    }
		
	}
	public function validateName($attribute, $params)
	{
    
		$condition = "isActive='Y' ";
		if($this->id>0){
			$condition .=" AND id!='".$this->id."' ";
		}
	    $name = $this->$attribute;
	    $condition .= " AND isActive='Y'  AND country_name='" . $name . "'";
	 	$exst_model = self::model()->find(array('condition' => $condition));
		    if (!empty($exst_model)) {
		        $this->addError($attribute, 'Name must be unique for country.');
		    }
		
	}
	public static function getAll() {
        $condition = " isActive='Y'";
        $model = self::model()->findAll(array('select' => array('id', 'country_name'), 'condition'=>$condition,'order' => 'country_name'));
        return CHtml::listData($model, 'id', 'country_name');
    }
}
