<?php

/**
 * Description of DashboardCount
 *
 * @author Manu
 */
class DashboardCount {

    private $userId;

    const NEAR_EXPIRY_DAYS = 30;

    public function __construct($_userId = 0) {
        $this->userId = $_userId;
    }

    public function getLiveCustomer() {
        $today = date("Y-m-d");
        $sql = "select count(*) from crm_mas_customer where date(customer_lock_date) >= '$today' AND status ='c' ";
        if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_customer_view_all"])) {

        } else {
            $sql .= " AND current_sp = " . $this->userId;
        }
        $qty = (int) Yii::app()->db->createCommand($sql)->queryScalar();
        return $qty;
    }

    public function getExpiryCustomer() {
        $today = date("Y-m-d");
        $sql = "select count(*) from crm_mas_customer where date(customer_lock_date) < '$today' AND status ='c' ";
//        if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_customer_view_all"])) {
//
//        } else {
//            $sql .= " AND current_sp = " . $this->userId;
//        }
        $qty = (int) Yii::app()->db->createCommand($sql)->queryScalar();
        return $qty;
    }

    public function getLiveProspect() {
        $today = date("Y-m-d");
        $sql = "select count(*) from crm_mas_customer where date(prospect_lock_date) >= '$today' AND status ='p' ";
        if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_customer_view_all"])) {

        } else {
            $sql .= " AND current_sp = " . $this->userId;
        }
        $qty = (int) Yii::app()->db->createCommand($sql)->queryScalar();
        return $qty;
    }

    public function getExpiryProspect() {
        $today = date("Y-m-d");
        $sql = "select count(*) from crm_mas_customer where date(prospect_lock_date) < '$today' AND status ='p' ";
//        if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_customer_view_all"])) {
//
//        } else {
//            $sql .= " AND current_sp = " . $this->userId;
//        }
        $qty = (int) Yii::app()->db->createCommand($sql)->queryScalar();
        return $qty;
    }

    public function getNearExpiryCustomer() {
        $today = date("Y-m-d");
        $last_day = date("Y-m-d", strtotime("+" . DashboardCount::NEAR_EXPIRY_DAYS . " days"));
        $sql = "select count(*) from crm_mas_customer where date(customer_lock_date) >= '$today' AND  date(customer_lock_date) <= '$last_day' AND status ='c' ";
        if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_customer_view_all"])) {

        } else {
            $sql .= " AND current_sp = " . $this->userId;
        }
        $qty = (int) Yii::app()->db->createCommand($sql)->queryScalar();
        //echo $sql;
        return $qty;
    }

    public function getNearExpiryProspect() {
        $today = date("Y-m-d");
        $last_day = date("Y-m-d", strtotime("+" . DashboardCount::NEAR_EXPIRY_DAYS . " days"));
        $sql = "select count(*) from crm_mas_customer where date(prospect_lock_date) >= '$today' AND  date(prospect_lock_date) <= '$last_day' AND status ='p' ";
        if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_customer_view_all"])) {

        } else {
            $sql .= " AND current_sp = " . $this->userId;
        }
        $qty = (int) Yii::app()->db->createCommand($sql)->queryScalar();
        return $qty;
    }

}
