<?php

/**
 * This is the model class for table "{{company_contact}}".
 *
 * The followings are the available columns in table '{{company_contact}}':
 * @property integer $id
 * @property string $first_name
 * @property string $last_name
 * @property string $position
 * @property integer $company_id
 * @property integer $priority
 * @property string $phone
 * @property string $mobile
 * @property string $email
 * @property string $country
 * @property string $state
 * @property string $address
 * @property string $post_code
 * @property string $suburb
 * @property string $status
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class CompanyContact extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{company_contact}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('first_name, last_name, position, company_id, phone, mobile, email, country, state, address, post_code, suburb', 'required'),
			array('company_id, priority, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('first_name, last_name, position, email, post_code, suburb', 'length', 'max'=>100),
			array('phone, mobile', 'length', 'max'=>50),
			array('country, state, address', 'length', 'max'=>255),
			array('status', 'length', 'max'=>1),
			array('created_date_time, updated_date_time', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, first_name, last_name, position, company_id, priority, phone, mobile, email, country, state, address, post_code, suburb, status, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		     
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'first_name' => 'First Name',
			'last_name' => 'Last Name',
			'position' => 'Position',
			'company_id' => 'Company',
			'priority' => 'Priority',
			'phone' => 'Phone',
			'mobile' => 'Mobile',
			'email' => 'Email',
			'country' => 'Country',
			'state' => 'State',
			'address' => 'Address',
			'post_code' => 'Post Code',
			'suburb' => 'Suburb',
			'status' => 'Status',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('first_name',$this->first_name,true);
		$criteria->compare('last_name',$this->last_name,true);
		$criteria->compare('position',$this->position,true);
		$criteria->compare('company_id',$this->company_id);
		$criteria->compare('priority',$this->priority);
		$criteria->compare('phone',$this->phone,true);
		$criteria->compare('mobile',$this->mobile,true);
		$criteria->compare('email',$this->email,true);
		$criteria->compare('country',$this->country,true);
		$criteria->compare('state',$this->state,true);
		$criteria->compare('address',$this->address,true);
		$criteria->compare('post_code',$this->post_code,true);
		$criteria->compare('suburb',$this->suburb,true);
		$criteria->compare('status',$this->status,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return CompanyContact the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
