<?php

/**
 * This is the model class for table "{{company}}".
 *
 * The followings are the available columns in table '{{company}}':
 * @property integer $id
 * @property string $company_name
 * @property string $phone
 * @property string $email
 * @property string $country
 * @property string $state
 * @property string $suburb
 * @property string $group_company_id
 * @property string $company_type
 * @property integer $sales_person_id
 * @property string $address
 * @property string $po_box
 * @property string $tagged_companies
 * @property string $website
 * @property string $status
 * @property string $industry_id
 * @property string $category_id
 * @property integer $created_by
 * @property string $created_date
 * @property integer $updated_by
 * @property string $updated_date
 */
class Company extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */

	 public $change_agencies_id;
    public $change_company_id;
	public function tableName()
	{
		return '{{company}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('company_name, phone, email, country, state, suburb, group_company_id, company_type, sales_person_id, address, po_box, tagged_companies, status, industry_id, category_id', 'required'),
			array('sales_person_id, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('company_name, country, state, group_company_id, company_type, address, tagged_companies', 'length', 'max'=>255),
			array('phone, email', 'length', 'max'=>50),
			array('suburb, po_box, website', 'length', 'max'=>100),
			array('status', 'length', 'max'=>1),
			array('industry_id, category_id', 'length', 'max'=>500),
			array('created_date, updated_date', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, company_name, phone, email, country, state, suburb, group_company_id, company_type, sales_person_id, address, po_box, tagged_companies, website, status, industry_id, category_id, created_by, created_date, updated_by, updated_date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		      
		       'ContactName' => array(self::HAS_ONE,'CompanyContact', 'company_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'company_name' => 'Company Name',
			'phone' => 'Phone',
			'email' => 'Email',
			'country' => 'Country',
			'state' => 'State',
			'suburb' => 'Suburb',
			'group_company_id' => 'Group Company',
			'company_type' => 'Company Type',
			'sales_person_id' => 'Sales Person',
			'address' => 'Address',
			'po_box' => 'Po Box',
			'tagged_companies' => 'Tagged Companies',
			'website' => 'Website',
			'status' => 'Status',
			'industry_id' => 'Industry',
			'category_id' => 'Category',
			'created_by' => 'Created By',
			'created_date' => 'Created Date',
			'updated_by' => 'Updated By',
			'updated_date' => 'Updated Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('company_name',$this->company_name,true);
		$criteria->compare('phone',$this->phone,true);
		$criteria->compare('email',$this->email,true);
		$criteria->compare('country',$this->country,true);
		$criteria->compare('state',$this->state,true);
		$criteria->compare('suburb',$this->suburb,true);
		$criteria->compare('group_company_id',$this->group_company_id,true);
		$criteria->compare('company_type',$this->company_type,true);
		$criteria->compare('sales_person_id',$this->sales_person_id);
		$criteria->compare('address',$this->address,true);
		$criteria->compare('po_box',$this->po_box,true);
		$criteria->compare('tagged_companies',$this->tagged_companies,true);
		$criteria->compare('website',$this->website,true);
		$criteria->compare('status',$this->status,true);
		$criteria->compare('industry_id',$this->industry_id,true);
		$criteria->compare('category_id',$this->category_id,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date',$this->created_date,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date',$this->updated_date,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Company the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	public static function getAll() {
        $condition = " status='Y'";
        $model = self::model()->findAll(array('select' => array('id', 'company_name'), 'condition'=>$condition,'order' => 'company_name'));
        return CHtml::listData($model, 'id', 'company_name');
    }
}
