<?php

/**
 * This is the model class for table "{{app_users}}".
 *
 * The followings are the available columns in table '{{app_users}}':
 * @property integer $id
 * @property string $first_name
 * @property string $last_name
 * @property string $phone_no
 * @property string $email_id
 * @property string $token
 * @property string $user_name
 * @property string $user_pwd
 * @property string $user_default_image
 * @property string $location
 * @property string $auth_key
 * @property string $banner_image
 * @property string $designation
 * @property string $organization
 * @property string $isActive
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class AppUsers extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{app_users}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('first_name, last_name, phone_no, email_id, user_name, user_pwd, created_by, created_date_time', 'required'),
			array('created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('first_name, last_name, email_id, user_default_image, auth_key', 'length', 'max'=>50),
			array('phone_no, token, user_name, user_pwd', 'length', 'max'=>100),
			array('location, banner_image, designation, organization', 'length', 'max'=>255),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, first_name, last_name, phone_no, email_id, token, user_name, user_pwd, user_default_image, location, auth_key, banner_image, designation, organization, isActive, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'first_name' => 'First Name',
			'last_name' => 'Last Name',
			'phone_no' => 'Phone No',
			'email_id' => 'Email',
			'token' => 'Token',
			'user_name' => 'User Name',
			'user_pwd' => 'User Password',
			'user_default_image' => 'User Default Image',
			'location' => 'Location',
			'auth_key' => 'Auth Key',
			'banner_image' => 'Banner Image',
			'designation' => 'Designation',
			'organization' => 'Organization',
			'isActive' => 'Is Active',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('first_name',$this->first_name,true);
		$criteria->compare('last_name',$this->last_name,true);
		$criteria->compare('phone_no',$this->phone_no,true);
		$criteria->compare('email_id',$this->email_id,true);
		$criteria->compare('token',$this->token,true);
		$criteria->compare('user_name',$this->user_name,true);
		$criteria->compare('user_pwd',$this->user_pwd,true);
		$criteria->compare('user_default_image',$this->user_default_image,true);
		$criteria->compare('location',$this->location,true);
		$criteria->compare('auth_key',$this->auth_key,true);
		$criteria->compare('banner_image',$this->banner_image,true);
		$criteria->compare('designation',$this->designation,true);
		$criteria->compare('organization',$this->organization,true);
		$criteria->compare('isActive',$this->isActive,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return AppUsers the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	function beforeSave() {
        if (isset($_POST['AppUsers']['user_pwd']) && $_POST['AppUsers']['user_pwd'] != '') {
            //START Code modified on 08-04-2016 for secured password
            $salt = '$2a$10$1qAz2wSx3eDc4rFv5tGb5t';
            $this->user_pwd = crypt($_POST['AppUsers']['user_pwd'], $salt);
        }
        return true;
    }
}
