<?php

/**
 * This is the model class for table "{{app_notification}}".
 *
 * The followings are the available columns in table '{{app_notification}}':
 * @property integer $id
 * @property integer $user_id
 * @property integer $event_id
 * @property integer $story_id
 * @property integer $youtube_link_id
 * @property integer $magazine_id
 * @property string $IsActive
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class AppNotification extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{app_notification}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_id, event_id, story_id, youtube_link_id, magazine_id, created_by, created_date_time, updated_by, updated_date_time', 'required'),
			array('user_id, event_id, story_id, youtube_link_id, magazine_id, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('IsActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, user_id, event_id, story_id, youtube_link_id, magazine_id, IsActive, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		   'UserName' => array(self::BELONGS_TO,'AppUsers', 'user_id'),
		   'EventName' => array(self::BELONGS_TO,'AppEvents', 'event_id'),
		   'StoryName' => array(self::BELONGS_TO,'AppStory', 'story_id'),
		   'YoutubeLink' => array(self::BELONGS_TO,'AppYoutubeLink', 'youtube_link_id'),
		   'MagazineName' => array(self::BELONGS_TO,'MasterMagazine', 'magazine_id'),
		   
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'user_id' => 'User',
			'event_id' => 'Event',
			'story_id' => 'Story',
			'youtube_link_id' => 'Youtube Link',
			'magazine_id' => 'Magazine',
			'IsActive' => 'Is Active',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('event_id',$this->event_id);
		$criteria->compare('story_id',$this->story_id);
		$criteria->compare('youtube_link_id',$this->youtube_link_id);
		$criteria->compare('magazine_id',$this->magazine_id);
		$criteria->compare('IsActive',$this->IsActive,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return AppNotification the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
