<?php

/**
 * This is the model class for table "{{app_events}}".
 *
 * The followings are the available columns in table '{{app_events}}':
 * @property integer $id
 * @property string $isActive
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 * @property string $event_name
 * @property string $event_image
 * @property string $event_link
 * @property string $event_text
 */
class AppEvents extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{app_events}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('created_by, created_date_time, event_name', 'required'),
			array('created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('isActive', 'length', 'max'=>1),
			array('event_name, event_image, event_link, event_text', 'length', 'max'=>255),
			array('event_name','validateEvent'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, isActive, created_by, created_date_time, updated_by, updated_date_time, event_name, event_image, event_link, event_text', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'isActive' => 'Is Active',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
			'event_name' => 'Event Name',
			'event_image' => 'Event Image',
			'event_link' => 'Event Link',
			'event_text' => 'Event Text',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('isActive',$this->isActive,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);
		$criteria->compare('event_name',$this->event_name,true);
		$criteria->compare('event_image',$this->event_image,true);
		$criteria->compare('event_link',$this->event_link,true);
		$criteria->compare('event_text',$this->event_text,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return AppEvents the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	public function validateEvent($attribute, $params)
	{
    
		$condition = "isActive='Y' ";
		if($this->id>0){
			$condition .=" AND id!='".$this->id."' ";
		}
	    $code = $this->$attribute;
	    $condition .= "  AND event_name='" . $code . "'";
	 	$exst_model = self::model()->find(array('condition' => $condition));
		    if (!empty($exst_model)) {
		        $this->addError($attribute, 'Event Name must be unique');
		    }
		
	}
}
