<?php

/**
 * This is the model class for table "{{_user_type}}".
 *
 * The followings are the available columns in table '{{_user_type}}':
 * @property integer $id
 * @property string $type
 * @property string $isActive
 *
 * The followings are the available model relations:
 * @property User[] $users
 */
class UserType extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UserType the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{_user_type}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('type, isActive', 'required'),
			array('type', 'length', 'max'=>255),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, type, isActive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'users' => array(self::HAS_MANY, 'User', 'user_type_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'type' => 'Type',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.
                $type= trim(Yii::app()->request->getParam('type'));
		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('type',$this->type,true);
		$criteria->compare('isActive',$this->isActive,true);
                if(!empty($type))
                {
                    $criteria->addCondition('t.type like "%'.$type.'%"','AND');
                }
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
			'sort'=>array(
            'defaultOrder'=>'t.id DESC',
       	 	),
                    'pagination'=>false
//			'pagination'=>array('pageSize'=>Yii::app()->params['defaultPageSize'])
		));
	}
	
	//Get groups

	//param group id, returning model

	public function getUserTypes($needList=true,$gid=null)

	{

		$condition	=	'isActive =  "Y" ';

		if($gid!=null) 

		$condition	.=	'AND id =  '.$gid;

		$model		=	UserType::model()->findAll(array('condition'=>$condition,'order'=>'id'));

		if($needList)

			return CHtml::listData($model, 'id', 'type');

		return $model;

	}
	public static function getUserType()
	{
		$condition='isActive =  "Y" ';
		$model=UserType::model()->findAll(array('condition'=>$condition));
                return CHtml::listData($model, 'id', 'type');
	}
}
