<?php

/**
 * This is the model class for table "{{_industry}}".
 *
 * The followings are the available columns in table '{{_industry}}':
 * @property string $id
 * @property string $industry_name
 * @property string $description
 * @property string $isActive
 *
 * The followings are the available model relations:
 * @property User[] $users
 */
 class SecondaryActiveRecord1 extends CActiveRecord {
    public function getDbConnection() {
        return Yii::app()->support;
    }
}
class SupportIndustry extends SecondaryActiveRecord1
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Industry the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{_industry}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('industry_name, description', 'required'),
			array('industry_name', 'length', 'max'=>255),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, industry_name, description, isActive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			//'users' => array(self::HAS_MANY, 'SupportUser', 'industry_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'industry_name' => 'Industry Name',
			'description' => 'Description',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);
		$criteria->compare('industry_name',$this->industry_name,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('isActive',$this->isActive,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	
	public function getAllIndustries()
	{
		return CHtml::listData(SupportIndustry::model()->findAll(array('condition'=>'isActive="Y"','order'=>'id')), 'id', 'industry_name');
	}

}