<?php

/**
 * This is the model class for table "{{_nbd_product_terms_conditions}}".
 *
 * The followings are the available columns in table '{{_nbd_product_terms_conditions}}':
 * @property string $id
 * @property string $terms_and_conditions
 */
class ProductTerms extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Country the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{_nbd_product_terms_conditions}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('terms_and_conditions', 'required'),
			array('terms_and_conditions', 'length', 'max'=>5000),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, terms_and_conditions', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'terms_and_conditions' => 'Terms and Conditions',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.
                $search= trim(Yii::app()->request->getParam('searchterm'));

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);
		$criteria->compare('terms_and_conditions',$this->terms_and_conditions,true);
                if(!empty($search))
                {
                    $criteria->addCondition('t.terms_and_conditions like "%'.$search.'%"');
                }
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
			'sort'=>array(
                        'defaultOrder'=>'t.id DESC',
       	 	),
			'pagination'=>array('pageSize'=>Yii::app()->params['defaultPageSize'])
		));
	}
	
	
	
}