<?php

/**
 * This is the model class for table "{{_resource_type}}".
 *
 * The followings are the available columns in table '{{_resource_type}}':
 * @property integer $id
 * @property string $resource_type
 *
 * The followings are the available model relations:
 * @property Resource[] $resources
 */
class ProductResourceType extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ProductResourceType the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{_product_resource_type}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('resource_type', 'required'),
			array('resource_type', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, resource_type,isActive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'resources' => array(self::HAS_MANY, 'Resource', 'resource_type_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'resource_type' => 'Resource Type',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('resource_type',$this->resource_type,true);
		$criteria->compare('isActive',$this->resource_type,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
			'defaultOrder'=>'t.id DESC',
			'pagination'=>array('pageSize'=>Yii::app()->params['defaultPageSize'])
		));
	}
	
	//Get Category(s)
	//param group id, returning model
	public function getProductResourceType($needList=true,$cid=null)
	{
		$condition	=	'isActive =  "Y" ';
		if($cid!=null) 
		$condition	.=	'AND id =  '.$cid;
		$model		=	ProductResourceType::model()->findAll(array('condition'=>$condition,'order'=>'id'));
		if($needList)
			return CHtml::listData($model, 'id', 'resource_type');
		return $model;
	}
}