<?php

/**
 * This is the model class for table "{{_product_mapping}}".
 *
 * The followings are the available columns in table '{{_product_mapping}}':
 * @property string $id
 * @property string $product_id
 * @property string $main_category_id
 * @property string $category_id
 * @property string $sub_category_id
 * @property string $product_category_id
 * @property string $product_sub_category_id
 * @property string $isActive
 */
class ProductMapping extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{_product_mapping}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('product_id, main_category_id, category_id, sub_category_id, product_category_id, product_sub_category_id', 'required'),
			array('product_id, main_category_id, category_id, sub_category_id, product_category_id, product_sub_category_id', 'length', 'max'=>20),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, product_id, main_category_id, category_id, sub_category_id, product_category_id, product_sub_category_id, isActive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'product' => array(self::BELONGS_TO, 'Product', 'product_id')
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'product_id' => 'Product',
			'main_category_id' => 'Main Category',
			'category_id' => 'Category',
			'sub_category_id' => 'Sub Category',
			'product_category_id' => 'Product Category',
			'product_sub_category_id' => 'Product Sub Category',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);
		$criteria->compare('product_id',$this->product_id,true);
		$criteria->compare('main_category_id',$this->main_category_id,true);
		$criteria->compare('category_id',$this->category_id,true);
		$criteria->compare('sub_category_id',$this->sub_category_id,true);
		$criteria->compare('product_category_id',$this->product_category_id,true);
		$criteria->compare('product_sub_category_id',$this->product_sub_category_id,true);
		$criteria->compare('isActive',$this->isActive,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ProductMapping the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
