<?php

/**
 * This is the model class for table "{{_product_filter_feature}}".
 *
 * The followings are the available columns in table '{{_product_filter_feature}}':
 * @property integer $id
 * @property integer $product_id
 * @property integer $product_category_feature_id
 * @property integer $product_sub_category_feature_id
 * @property string $isActive
 */
class ProductFilterFeatureMultiple extends CActiveRecord
{
    public $main_category_id;
    public $category_feature_id;
    public $sub_category_feature_id;
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{_product_filter_feature}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('main_category_id,product_id,category_id, product_category_feature_id, product_sub_category_feature_id', 'required'),
			array('product_id, product_category_feature_id, product_sub_category_feature_id', 'numerical', 'integerOnly'=>true),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, product_id, product_category_feature_id, product_sub_category_feature_id, isActive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                      'category' => array(self::BELONGS_TO, 'Category', 'category_id'),
                    'product' => array(self::BELONGS_TO, 'Product', 'product_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'product_id' => 'Product',
			'product_category_feature_id' => 'Product Category Feature',
			'product_sub_category_feature_id' => 'Product Sub Category Feature',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

                $search = trim(Yii::app()->request->getParam('searchterm'));
                
                
		$criteria=new CDbCriteria;
                $criteria->with = array('category','product');
		$criteria->compare('t.id',$this->id);
		$criteria->compare('t.product_id',$this->product_id);
		$criteria->compare('t.product_category_feature_id',$this->product_category_feature_id);
		$criteria->compare('t.product_sub_category_feature_id',$this->product_sub_category_feature_id);
		$criteria->compare('t.isActive',$this->isActive,true);
                $criteria->group='t.product_id,t.category_id';
                
                if (!empty($search)) {
        	$criteria->addCondition('product.product_name like "%' . $search . '%" OR product.product_generic_name like "%' . $search . '%" OR category.category like "%' . $search . '%"', 'AND');
        }
                
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ProductFilterFeature the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
