<?php

/**
 * This is the model class for table "{{_product_feature}}".
 *
 * The followings are the available columns in table '{{_product_feature}}':
 * @property string $id
 * @property string $product_id
 * @property string $feature_id
 * @property string $feature_value
 * @property string $isActive
 *
 * The followings are the available model relations:
 * @property Product $product
 */
class ProductFeatureRelation extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ProductFeature the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{_product_feature_relation}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			//array('product_id, feature_id, feature_value', 'required'),
			array('product_id, feature_id', 'length', 'max'=>20),
			array('feature_value', 'length', 'min'=>1),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, product_id, feature_id, feature_value, isActive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'feature' => array(self::BELONGS_TO, 'ProductFeature', 'feature_id'),
			'product' => array(self::BELONGS_TO, 'Product', 'product_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'product_id' => 'Product',
			'feature_id' => 'Feature',
			'feature_value' => 'Feature Value',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);
		$criteria->compare('product_id',$this->product_id,true);
		$criteria->compare('feature_id',$this->feature_id,true);
		$criteria->compare('feature_value',$this->feature_value,true);
		$criteria->compare('isActive',$this->isActive,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
			'sort'=>array(
            'defaultOrder'=>'t.id DESC',
       	 	),
			'pagination'=>array('pageSize'=>Yii::app()->params['defaultPageSize'])
		));
	}
}
